/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListObjectParentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Map<String, String> parents;
    private String nextToken;
    private List<ObjectIdentifierAndLinkNameTuple> parentLinks;

    public Map<String, String> getParents() {
        return this.parents;
    }

    public void setParents(Map<String, String> parents) {
        this.parents = parents;
    }

    public ListObjectParentsResult withParents(Map<String, String> parents) {
        this.setParents(parents);
        return this;
    }

    public ListObjectParentsResult addParentsEntry(String key, String value) {
        if (null == this.parents) {
            this.parents = new HashMap<String, String>();
        }
        if (this.parents.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parents.put(key, value);
        return this;
    }

    public ListObjectParentsResult clearParentsEntries() {
        this.parents = null;
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListObjectParentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ObjectIdentifierAndLinkNameTuple> getParentLinks() {
        return this.parentLinks;
    }

    public void setParentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
        if (parentLinks == null) {
            this.parentLinks = null;
            return;
        }
        this.parentLinks = new ArrayList<ObjectIdentifierAndLinkNameTuple>(parentLinks);
    }

    public ListObjectParentsResult withParentLinks(ObjectIdentifierAndLinkNameTuple ... parentLinks) {
        if (this.parentLinks == null) {
            this.setParentLinks(new ArrayList<ObjectIdentifierAndLinkNameTuple>(parentLinks.length));
        }
        for (ObjectIdentifierAndLinkNameTuple ele : parentLinks) {
            this.parentLinks.add(ele);
        }
        return this;
    }

    public ListObjectParentsResult withParentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
        this.setParentLinks(parentLinks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParents() != null) {
            sb.append("Parents: ").append(this.getParents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getParentLinks() != null) {
            sb.append("ParentLinks: ").append(this.getParentLinks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentsResult)) {
            return false;
        }
        ListObjectParentsResult other = (ListObjectParentsResult)obj;
        if (other.getParents() == null ^ this.getParents() == null) {
            return false;
        }
        if (other.getParents() != null && !other.getParents().equals(this.getParents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getParentLinks() == null ^ this.getParentLinks() == null) {
            return false;
        }
        return other.getParentLinks() == null || other.getParentLinks().equals(this.getParentLinks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParents() == null ? 0 : this.getParents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getParentLinks() == null ? 0 : this.getParentLinks().hashCode());
        return hashCode;
    }

    public ListObjectParentsResult clone() {
        try {
            return (ListObjectParentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

