/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanroomsml.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanroomsml.model.ColumnSchema;
import com.amazonaws.services.cleanroomsml.model.DataSource;
import com.amazonaws.services.cleanroomsml.model.transform.DatasetInputConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatasetInputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColumnSchema> schema;
    private DataSource dataSource;

    public List<ColumnSchema> getSchema() {
        return this.schema;
    }

    public void setSchema(Collection<ColumnSchema> schema) {
        if (schema == null) {
            this.schema = null;
            return;
        }
        this.schema = new ArrayList<ColumnSchema>(schema);
    }

    public DatasetInputConfig withSchema(ColumnSchema ... schema) {
        if (this.schema == null) {
            this.setSchema(new ArrayList<ColumnSchema>(schema.length));
        }
        for (ColumnSchema ele : schema) {
            this.schema.add(ele);
        }
        return this;
    }

    public DatasetInputConfig withSchema(Collection<ColumnSchema> schema) {
        this.setSchema(schema);
        return this;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatasetInputConfig withDataSource(DataSource dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema()).append(",");
        }
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetInputConfig)) {
            return false;
        }
        DatasetInputConfig other = (DatasetInputConfig)obj;
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        if (other.getSchema() != null && !other.getSchema().equals(this.getSchema())) {
            return false;
        }
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        return other.getDataSource() == null || other.getDataSource().equals(this.getDataSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        return hashCode;
    }

    public DatasetInputConfig clone() {
        try {
            return (DatasetInputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatasetInputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

