/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.MemberAbility;
import com.amazonaws.services.cleanrooms.model.PaymentConfiguration;
import com.amazonaws.services.cleanrooms.model.transform.MemberSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemberSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private List<String> memberAbilities;
    private String displayName;
    private PaymentConfiguration paymentConfiguration;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public MemberSpecification withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public List<String> getMemberAbilities() {
        return this.memberAbilities;
    }

    public void setMemberAbilities(Collection<String> memberAbilities) {
        if (memberAbilities == null) {
            this.memberAbilities = null;
            return;
        }
        this.memberAbilities = new ArrayList<String>(memberAbilities);
    }

    public MemberSpecification withMemberAbilities(String ... memberAbilities) {
        if (this.memberAbilities == null) {
            this.setMemberAbilities(new ArrayList<String>(memberAbilities.length));
        }
        for (String ele : memberAbilities) {
            this.memberAbilities.add(ele);
        }
        return this;
    }

    public MemberSpecification withMemberAbilities(Collection<String> memberAbilities) {
        this.setMemberAbilities(memberAbilities);
        return this;
    }

    public MemberSpecification withMemberAbilities(MemberAbility ... memberAbilities) {
        ArrayList<String> memberAbilitiesCopy = new ArrayList<String>(memberAbilities.length);
        for (MemberAbility value : memberAbilities) {
            memberAbilitiesCopy.add(value.toString());
        }
        if (this.getMemberAbilities() == null) {
            this.setMemberAbilities(memberAbilitiesCopy);
        } else {
            this.getMemberAbilities().addAll(memberAbilitiesCopy);
        }
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MemberSpecification withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setPaymentConfiguration(PaymentConfiguration paymentConfiguration) {
        this.paymentConfiguration = paymentConfiguration;
    }

    public PaymentConfiguration getPaymentConfiguration() {
        return this.paymentConfiguration;
    }

    public MemberSpecification withPaymentConfiguration(PaymentConfiguration paymentConfiguration) {
        this.setPaymentConfiguration(paymentConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getMemberAbilities() != null) {
            sb.append("MemberAbilities: ").append(this.getMemberAbilities()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getPaymentConfiguration() != null) {
            sb.append("PaymentConfiguration: ").append(this.getPaymentConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSpecification)) {
            return false;
        }
        MemberSpecification other = (MemberSpecification)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getMemberAbilities() == null ^ this.getMemberAbilities() == null) {
            return false;
        }
        if (other.getMemberAbilities() != null && !other.getMemberAbilities().equals(this.getMemberAbilities())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getPaymentConfiguration() == null ^ this.getPaymentConfiguration() == null) {
            return false;
        }
        return other.getPaymentConfiguration() == null || other.getPaymentConfiguration().equals(this.getPaymentConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getMemberAbilities() == null ? 0 : this.getMemberAbilities().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentConfiguration() == null ? 0 : this.getPaymentConfiguration().hashCode());
        return hashCode;
    }

    public MemberSpecification clone() {
        try {
            return (MemberSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MemberSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

