/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmessaging.model.MessageAttributeValue;
import com.amazonaws.services.chimesdkmessaging.model.PushNotificationConfiguration;
import com.amazonaws.services.chimesdkmessaging.model.transform.ChannelMessageCallbackMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ChannelMessageCallback
implements Serializable,
Cloneable,
StructuredPojo {
    private String messageId;
    private String content;
    private String metadata;
    private PushNotificationConfiguration pushNotification;
    private Map<String, MessageAttributeValue> messageAttributes;
    private String subChannelId;

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public ChannelMessageCallback withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public ChannelMessageCallback withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public ChannelMessageCallback withMetadata(String metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public void setPushNotification(PushNotificationConfiguration pushNotification) {
        this.pushNotification = pushNotification;
    }

    public PushNotificationConfiguration getPushNotification() {
        return this.pushNotification;
    }

    public ChannelMessageCallback withPushNotification(PushNotificationConfiguration pushNotification) {
        this.setPushNotification(pushNotification);
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public ChannelMessageCallback withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.setMessageAttributes(messageAttributes);
        return this;
    }

    public ChannelMessageCallback addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new HashMap<String, MessageAttributeValue>();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public ChannelMessageCallback clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public void setSubChannelId(String subChannelId) {
        this.subChannelId = subChannelId;
    }

    public String getSubChannelId() {
        return this.subChannelId;
    }

    public ChannelMessageCallback withSubChannelId(String subChannelId) {
        this.setSubChannelId(subChannelId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessageId() != null) {
            sb.append("MessageId: ").append(this.getMessageId()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPushNotification() != null) {
            sb.append("PushNotification: ").append(this.getPushNotification()).append(",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSubChannelId() != null) {
            sb.append("SubChannelId: ").append(this.getSubChannelId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageCallback)) {
            return false;
        }
        ChannelMessageCallback other = (ChannelMessageCallback)obj;
        if (other.getMessageId() == null ^ this.getMessageId() == null) {
            return false;
        }
        if (other.getMessageId() != null && !other.getMessageId().equals(this.getMessageId())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getPushNotification() == null ^ this.getPushNotification() == null) {
            return false;
        }
        if (other.getPushNotification() != null && !other.getPushNotification().equals(this.getPushNotification())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        if (other.getMessageAttributes() != null && !other.getMessageAttributes().equals(this.getMessageAttributes())) {
            return false;
        }
        if (other.getSubChannelId() == null ^ this.getSubChannelId() == null) {
            return false;
        }
        return other.getSubChannelId() == null || other.getSubChannelId().equals(this.getSubChannelId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessageId() == null ? 0 : this.getMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getPushNotification() == null ? 0 : this.getPushNotification().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSubChannelId() == null ? 0 : this.getSubChannelId().hashCode());
        return hashCode;
    }

    public ChannelMessageCallback clone() {
        try {
            return (ChannelMessageCallback)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMessageCallbackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

