/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockagent.model.MemoryConfiguration;
import java.util.List;

@SdkInternalApi
public class MemoryConfigurationMarshaller {
    private static final MarshallingInfo<List> ENABLEDMEMORYTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabledMemoryTypes").build();
    private static final MarshallingInfo<Integer> STORAGEDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageDays").build();
    private static final MemoryConfigurationMarshaller instance = new MemoryConfigurationMarshaller();

    public static MemoryConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MemoryConfiguration memoryConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (memoryConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(memoryConfiguration.getEnabledMemoryTypes(), ENABLEDMEMORYTYPES_BINDING);
            protocolMarshaller.marshall((Object)memoryConfiguration.getStorageDays(), STORAGEDAYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

