/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.EvaluationModelConfig;
import com.amazonaws.services.bedrock.model.transform.EvaluationInferenceConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluationInferenceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<EvaluationModelConfig> models;

    public List<EvaluationModelConfig> getModels() {
        return this.models;
    }

    public void setModels(Collection<EvaluationModelConfig> models) {
        if (models == null) {
            this.models = null;
            return;
        }
        this.models = new ArrayList<EvaluationModelConfig>(models);
    }

    public EvaluationInferenceConfig withModels(EvaluationModelConfig ... models) {
        if (this.models == null) {
            this.setModels(new ArrayList<EvaluationModelConfig>(models.length));
        }
        for (EvaluationModelConfig ele : models) {
            this.models.add(ele);
        }
        return this;
    }

    public EvaluationInferenceConfig withModels(Collection<EvaluationModelConfig> models) {
        this.setModels(models);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModels() != null) {
            sb.append("Models: ").append(this.getModels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfig)) {
            return false;
        }
        EvaluationInferenceConfig other = (EvaluationInferenceConfig)obj;
        if (other.getModels() == null ^ this.getModels() == null) {
            return false;
        }
        return other.getModels() == null || other.getModels().equals(this.getModels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModels() == null ? 0 : this.getModels().hashCode());
        return hashCode;
    }

    public EvaluationInferenceConfig clone() {
        try {
            return (EvaluationInferenceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationInferenceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

