/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bcmdataexports.model.CompressionOption;
import com.amazonaws.services.bcmdataexports.model.FormatOption;
import com.amazonaws.services.bcmdataexports.model.OverwriteOption;
import com.amazonaws.services.bcmdataexports.model.S3OutputType;
import com.amazonaws.services.bcmdataexports.model.transform.S3OutputConfigurationsMarshaller;
import java.io.Serializable;

public class S3OutputConfigurations
implements Serializable,
Cloneable,
StructuredPojo {
    private String compression;
    private String format;
    private String outputType;
    private String overwrite;

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompression() {
        return this.compression;
    }

    public S3OutputConfigurations withCompression(String compression) {
        this.setCompression(compression);
        return this;
    }

    public S3OutputConfigurations withCompression(CompressionOption compression) {
        this.compression = compression.toString();
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public S3OutputConfigurations withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public S3OutputConfigurations withFormat(FormatOption format) {
        this.format = format.toString();
        return this;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public S3OutputConfigurations withOutputType(String outputType) {
        this.setOutputType(outputType);
        return this;
    }

    public S3OutputConfigurations withOutputType(S3OutputType outputType) {
        this.outputType = outputType.toString();
        return this;
    }

    public void setOverwrite(String overwrite) {
        this.overwrite = overwrite;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public S3OutputConfigurations withOverwrite(String overwrite) {
        this.setOverwrite(overwrite);
        return this;
    }

    public S3OutputConfigurations withOverwrite(OverwriteOption overwrite) {
        this.overwrite = overwrite.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCompression() != null) {
            sb.append("Compression: ").append(this.getCompression()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getOutputType() != null) {
            sb.append("OutputType: ").append(this.getOutputType()).append(",");
        }
        if (this.getOverwrite() != null) {
            sb.append("Overwrite: ").append(this.getOverwrite());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputConfigurations)) {
            return false;
        }
        S3OutputConfigurations other = (S3OutputConfigurations)obj;
        if (other.getCompression() == null ^ this.getCompression() == null) {
            return false;
        }
        if (other.getCompression() != null && !other.getCompression().equals(this.getCompression())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getOutputType() == null ^ this.getOutputType() == null) {
            return false;
        }
        if (other.getOutputType() != null && !other.getOutputType().equals(this.getOutputType())) {
            return false;
        }
        if (other.getOverwrite() == null ^ this.getOverwrite() == null) {
            return false;
        }
        return other.getOverwrite() == null || other.getOverwrite().equals(this.getOverwrite());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCompression() == null ? 0 : this.getCompression().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getOutputType() == null ? 0 : this.getOutputType().hashCode());
        hashCode = 31 * hashCode + (this.getOverwrite() == null ? 0 : this.getOverwrite().hashCode());
        return hashCode;
    }

    public S3OutputConfigurations clone() {
        try {
            return (S3OutputConfigurations)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputConfigurationsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

