/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.bcmdataexports.model.Column;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetTableResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String description;
    private List<Column> schema;
    private String tableName;
    private Map<String, String> tableProperties;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public GetTableResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Column> getSchema() {
        return this.schema;
    }

    public void setSchema(Collection<Column> schema) {
        if (schema == null) {
            this.schema = null;
            return;
        }
        this.schema = new ArrayList<Column>(schema);
    }

    public GetTableResult withSchema(Column ... schema) {
        if (this.schema == null) {
            this.setSchema(new ArrayList<Column>(schema.length));
        }
        for (Column ele : schema) {
            this.schema.add(ele);
        }
        return this;
    }

    public GetTableResult withSchema(Collection<Column> schema) {
        this.setSchema(schema);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public GetTableResult withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public Map<String, String> getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(Map<String, String> tableProperties) {
        this.tableProperties = tableProperties;
    }

    public GetTableResult withTableProperties(Map<String, String> tableProperties) {
        this.setTableProperties(tableProperties);
        return this;
    }

    public GetTableResult addTablePropertiesEntry(String key, String value) {
        if (null == this.tableProperties) {
            this.tableProperties = new HashMap<String, String>();
        }
        if (this.tableProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tableProperties.put(key, value);
        return this;
    }

    public GetTableResult clearTablePropertiesEntries() {
        this.tableProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getTableProperties() != null) {
            sb.append("TableProperties: ").append(this.getTableProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableResult)) {
            return false;
        }
        GetTableResult other = (GetTableResult)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        if (other.getSchema() != null && !other.getSchema().equals(this.getSchema())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getTableProperties() == null ^ this.getTableProperties() == null) {
            return false;
        }
        return other.getTableProperties() == null || other.getTableProperties().equals(this.getTableProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getTableProperties() == null ? 0 : this.getTableProperties().hashCode());
        return hashCode;
    }

    public GetTableResult clone() {
        try {
            return (GetTableResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

