/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EksContainer;
import java.util.List;

@SdkInternalApi
public class EksContainerMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<String> IMAGEPULLPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePullPolicy").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("args").build();
    private static final MarshallingInfo<List> ENV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("env").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resources").build();
    private static final MarshallingInfo<List> VOLUMEMOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumeMounts").build();
    private static final MarshallingInfo<StructuredPojo> SECURITYCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityContext").build();
    private static final EksContainerMarshaller instance = new EksContainerMarshaller();

    public static EksContainerMarshaller getInstance() {
        return instance;
    }

    public void marshall(EksContainer eksContainer, ProtocolMarshaller protocolMarshaller) {
        if (eksContainer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eksContainer.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)eksContainer.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)eksContainer.getImagePullPolicy(), IMAGEPULLPOLICY_BINDING);
            protocolMarshaller.marshall(eksContainer.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall(eksContainer.getArgs(), ARGS_BINDING);
            protocolMarshaller.marshall(eksContainer.getEnv(), ENV_BINDING);
            protocolMarshaller.marshall((Object)eksContainer.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall(eksContainer.getVolumeMounts(), VOLUMEMOUNTS_BINDING);
            protocolMarshaller.marshall((Object)eksContainer.getSecurityContext(), SECURITYCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

