/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceRefreshesRequestMarshaller
implements Marshaller<Request<DescribeInstanceRefreshesRequest>, DescribeInstanceRefreshesRequest> {
    public Request<DescribeInstanceRefreshesRequest> marshall(DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) {
        if (describeInstanceRefreshesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceRefreshesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeInstanceRefreshes");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceRefreshesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeInstanceRefreshesRequest.getAutoScalingGroupName()));
        }
        if (!describeInstanceRefreshesRequest.getInstanceRefreshIds().isEmpty() || !((SdkInternalList)describeInstanceRefreshesRequest.getInstanceRefreshIds()).isAutoConstruct()) {
            SdkInternalList instanceRefreshIdsList = (SdkInternalList)describeInstanceRefreshesRequest.getInstanceRefreshIds();
            int instanceRefreshIdsListIndex = 1;
            for (String instanceRefreshIdsListValue : instanceRefreshIdsList) {
                if (instanceRefreshIdsListValue != null) {
                    request.addParameter("InstanceRefreshIds.member." + instanceRefreshIdsListIndex, StringUtils.fromString((String)instanceRefreshIdsListValue));
                }
                ++instanceRefreshIdsListIndex;
            }
        }
        if (describeInstanceRefreshesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceRefreshesRequest.getNextToken()));
        }
        if (describeInstanceRefreshesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeInstanceRefreshesRequest.getMaxRecords()));
        }
        return request;
    }
}

