/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.ControlSet;
import com.amazonaws.services.auditmanager.model.FrameworkType;
import com.amazonaws.services.auditmanager.model.transform.FrameworkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Framework
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String id;
    private String name;
    private String type;
    private String complianceType;
    private String description;
    private String logo;
    private String controlSources;
    private List<ControlSet> controlSets;
    private Date createdAt;
    private Date lastUpdatedAt;
    private String createdBy;
    private String lastUpdatedBy;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Framework withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Framework withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Framework withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Framework withType(String type) {
        this.setType(type);
        return this;
    }

    public Framework withType(FrameworkType type) {
        this.type = type.toString();
        return this;
    }

    public void setComplianceType(String complianceType) {
        this.complianceType = complianceType;
    }

    public String getComplianceType() {
        return this.complianceType;
    }

    public Framework withComplianceType(String complianceType) {
        this.setComplianceType(complianceType);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Framework withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLogo() {
        return this.logo;
    }

    public Framework withLogo(String logo) {
        this.setLogo(logo);
        return this;
    }

    public void setControlSources(String controlSources) {
        this.controlSources = controlSources;
    }

    public String getControlSources() {
        return this.controlSources;
    }

    public Framework withControlSources(String controlSources) {
        this.setControlSources(controlSources);
        return this;
    }

    public List<ControlSet> getControlSets() {
        return this.controlSets;
    }

    public void setControlSets(Collection<ControlSet> controlSets) {
        if (controlSets == null) {
            this.controlSets = null;
            return;
        }
        this.controlSets = new ArrayList<ControlSet>(controlSets);
    }

    public Framework withControlSets(ControlSet ... controlSets) {
        if (this.controlSets == null) {
            this.setControlSets(new ArrayList<ControlSet>(controlSets.length));
        }
        for (ControlSet ele : controlSets) {
            this.controlSets.add(ele);
        }
        return this;
    }

    public Framework withControlSets(Collection<ControlSet> controlSets) {
        this.setControlSets(controlSets);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Framework withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Framework withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Framework withCreatedBy(String createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Framework withLastUpdatedBy(String lastUpdatedBy) {
        this.setLastUpdatedBy(lastUpdatedBy);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Framework withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Framework addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Framework clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getComplianceType() != null) {
            sb.append("ComplianceType: ").append(this.getComplianceType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLogo() != null) {
            sb.append("Logo: ").append(this.getLogo()).append(",");
        }
        if (this.getControlSources() != null) {
            sb.append("ControlSources: ").append(this.getControlSources()).append(",");
        }
        if (this.getControlSets() != null) {
            sb.append("ControlSets: ").append(this.getControlSets()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getLastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.getLastUpdatedBy()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Framework)) {
            return false;
        }
        Framework other = (Framework)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getComplianceType() == null ^ this.getComplianceType() == null) {
            return false;
        }
        if (other.getComplianceType() != null && !other.getComplianceType().equals(this.getComplianceType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLogo() == null ^ this.getLogo() == null) {
            return false;
        }
        if (other.getLogo() != null && !other.getLogo().equals(this.getLogo())) {
            return false;
        }
        if (other.getControlSources() == null ^ this.getControlSources() == null) {
            return false;
        }
        if (other.getControlSources() != null && !other.getControlSources().equals(this.getControlSources())) {
            return false;
        }
        if (other.getControlSets() == null ^ this.getControlSets() == null) {
            return false;
        }
        if (other.getControlSets() != null && !other.getControlSets().equals(this.getControlSets())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getLastUpdatedBy() == null ^ this.getLastUpdatedBy() == null) {
            return false;
        }
        if (other.getLastUpdatedBy() != null && !other.getLastUpdatedBy().equals(this.getLastUpdatedBy())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceType() == null ? 0 : this.getComplianceType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLogo() == null ? 0 : this.getLogo().hashCode());
        hashCode = 31 * hashCode + (this.getControlSources() == null ? 0 : this.getControlSources().hashCode());
        hashCode = 31 * hashCode + (this.getControlSets() == null ? 0 : this.getControlSets().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedBy() == null ? 0 : this.getLastUpdatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Framework clone() {
        try {
            return (Framework)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FrameworkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

