/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.QueryExecution;
import java.util.List;

@SdkInternalApi
public class QueryExecutionMarshaller {
    private static final MarshallingInfo<String> QUERYEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryExecutionId").build();
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Query").build();
    private static final MarshallingInfo<String> STATEMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatementType").build();
    private static final MarshallingInfo<StructuredPojo> RESULTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> RESULTREUSECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultReuseConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> QUERYEXECUTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryExecutionContext").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> STATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistics").build();
    private static final MarshallingInfo<String> WORKGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkGroup").build();
    private static final MarshallingInfo<StructuredPojo> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<List> EXECUTIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionParameters").build();
    private static final MarshallingInfo<String> SUBSTATEMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubstatementType").build();
    private static final MarshallingInfo<StructuredPojo> QUERYRESULTSS3ACCESSGRANTSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryResultsS3AccessGrantsConfiguration").build();
    private static final QueryExecutionMarshaller instance = new QueryExecutionMarshaller();

    public static QueryExecutionMarshaller getInstance() {
        return instance;
    }

    public void marshall(QueryExecution queryExecution, ProtocolMarshaller protocolMarshaller) {
        if (queryExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)queryExecution.getQueryExecutionId(), QUERYEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getQuery(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getStatementType(), STATEMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getResultConfiguration(), RESULTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getResultReuseConfiguration(), RESULTREUSECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getQueryExecutionContext(), QUERYEXECUTIONCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getStatistics(), STATISTICS_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getWorkGroup(), WORKGROUP_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall(queryExecution.getExecutionParameters(), EXECUTIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getSubstatementType(), SUBSTATEMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.getQueryResultsS3AccessGrantsConfiguration(), QUERYRESULTSS3ACCESSGRANTSCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

