/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apptest.model.DataSet;

@SdkInternalApi
public class DataSetMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> CCSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccsid").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<Integer> LENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("length").build();
    private static final DataSetMarshaller instance = new DataSetMarshaller();

    public static DataSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSet dataSet, ProtocolMarshaller protocolMarshaller) {
        if (dataSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSet.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getCcsid(), CCSID_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getLength(), LENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

