/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appregistry.model.AssociationOption;
import com.amazonaws.services.appregistry.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssociateResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String application;
    private String resourceType;
    private String resource;
    private List<String> options;

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public AssociateResourceRequest withApplication(String application) {
        this.setApplication(application);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public AssociateResourceRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public AssociateResourceRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public AssociateResourceRequest withResource(String resource) {
        this.setResource(resource);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<String> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<String>(options);
    }

    public AssociateResourceRequest withOptions(String ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<String>(options.length));
        }
        for (String ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public AssociateResourceRequest withOptions(Collection<String> options) {
        this.setOptions(options);
        return this;
    }

    public AssociateResourceRequest withOptions(AssociationOption ... options) {
        ArrayList<String> optionsCopy = new ArrayList<String>(options.length);
        for (AssociationOption value : options) {
            optionsCopy.add(value.toString());
        }
        if (this.getOptions() == null) {
            this.setOptions(optionsCopy);
        } else {
            this.getOptions().addAll(optionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplication() != null) {
            sb.append("Application: ").append(this.getApplication()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceRequest)) {
            return false;
        }
        AssociateResourceRequest other = (AssociateResourceRequest)obj;
        if (other.getApplication() == null ^ this.getApplication() == null) {
            return false;
        }
        if (other.getApplication() != null && !other.getApplication().equals(this.getApplication())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplication() == null ? 0 : this.getApplication().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public AssociateResourceRequest clone() {
        return (AssociateResourceRequest)super.clone();
    }
}

