/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appmesh.model.RouteRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRoutesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<RouteRef> routes;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRoutesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<RouteRef> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Collection<RouteRef> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        this.routes = new ArrayList<RouteRef>(routes);
    }

    public ListRoutesResult withRoutes(RouteRef ... routes) {
        if (this.routes == null) {
            this.setRoutes(new ArrayList<RouteRef>(routes.length));
        }
        for (RouteRef ele : routes) {
            this.routes.add(ele);
        }
        return this;
    }

    public ListRoutesResult withRoutes(Collection<RouteRef> routes) {
        this.setRoutes(routes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRoutes() != null) {
            sb.append("Routes: ").append(this.getRoutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutesResult)) {
            return false;
        }
        ListRoutesResult other = (ListRoutesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        return other.getRoutes() == null || other.getRoutes().equals(this.getRoutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : this.getRoutes().hashCode());
        return hashCode;
    }

    public ListRoutesResult clone() {
        try {
            return (ListRoutesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

