/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.MetricReference;
import com.amazonaws.services.applicationsignals.model.transform.ServiceOperationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceOperation
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<MetricReference> metricReferences;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ServiceOperation withName(String name) {
        this.setName(name);
        return this;
    }

    public List<MetricReference> getMetricReferences() {
        return this.metricReferences;
    }

    public void setMetricReferences(Collection<MetricReference> metricReferences) {
        if (metricReferences == null) {
            this.metricReferences = null;
            return;
        }
        this.metricReferences = new ArrayList<MetricReference>(metricReferences);
    }

    public ServiceOperation withMetricReferences(MetricReference ... metricReferences) {
        if (this.metricReferences == null) {
            this.setMetricReferences(new ArrayList<MetricReference>(metricReferences.length));
        }
        for (MetricReference ele : metricReferences) {
            this.metricReferences.add(ele);
        }
        return this;
    }

    public ServiceOperation withMetricReferences(Collection<MetricReference> metricReferences) {
        this.setMetricReferences(metricReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getMetricReferences() != null) {
            sb.append("MetricReferences: ").append(this.getMetricReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOperation)) {
            return false;
        }
        ServiceOperation other = (ServiceOperation)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMetricReferences() == null ^ this.getMetricReferences() == null) {
            return false;
        }
        return other.getMetricReferences() == null || other.getMetricReferences().equals(this.getMetricReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricReferences() == null ? 0 : this.getMetricReferences().hashCode());
        return hashCode;
    }

    public ServiceOperation clone() {
        try {
            return (ServiceOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

