/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationinsights.model.ApplicationComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListComponentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationComponent> applicationComponentList;
    private String nextToken;

    public List<ApplicationComponent> getApplicationComponentList() {
        return this.applicationComponentList;
    }

    public void setApplicationComponentList(Collection<ApplicationComponent> applicationComponentList) {
        if (applicationComponentList == null) {
            this.applicationComponentList = null;
            return;
        }
        this.applicationComponentList = new ArrayList<ApplicationComponent>(applicationComponentList);
    }

    public ListComponentsResult withApplicationComponentList(ApplicationComponent ... applicationComponentList) {
        if (this.applicationComponentList == null) {
            this.setApplicationComponentList(new ArrayList<ApplicationComponent>(applicationComponentList.length));
        }
        for (ApplicationComponent ele : applicationComponentList) {
            this.applicationComponentList.add(ele);
        }
        return this;
    }

    public ListComponentsResult withApplicationComponentList(Collection<ApplicationComponent> applicationComponentList) {
        this.setApplicationComponentList(applicationComponentList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListComponentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationComponentList() != null) {
            sb.append("ApplicationComponentList: ").append(this.getApplicationComponentList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResult)) {
            return false;
        }
        ListComponentsResult other = (ListComponentsResult)obj;
        if (other.getApplicationComponentList() == null ^ this.getApplicationComponentList() == null) {
            return false;
        }
        if (other.getApplicationComponentList() != null && !other.getApplicationComponentList().equals(this.getApplicationComponentList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationComponentList() == null ? 0 : this.getApplicationComponentList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListComponentsResult clone() {
        try {
            return (ListComponentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

