/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.FileConfiguration;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class FileConfigurationMarshaller {
    private static final MarshallingInfo<List> FOLDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Folders").build();
    private static final MarshallingInfo<Map> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").build();
    private static final FileConfigurationMarshaller instance = new FileConfigurationMarshaller();

    public static FileConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileConfiguration fileConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (fileConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(fileConfiguration.getFolders(), FOLDERS_BINDING);
            protocolMarshaller.marshall(fileConfiguration.getFilters(), FILTERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

