/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.account;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.account.AWSAccountAsync;
import com.amazonaws.services.account.AWSAccountAsyncClientBuilder;
import com.amazonaws.services.account.AWSAccountClient;
import com.amazonaws.services.account.model.DeleteAlternateContactRequest;
import com.amazonaws.services.account.model.DeleteAlternateContactResult;
import com.amazonaws.services.account.model.GetAlternateContactRequest;
import com.amazonaws.services.account.model.GetAlternateContactResult;
import com.amazonaws.services.account.model.PutAlternateContactRequest;
import com.amazonaws.services.account.model.PutAlternateContactResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAccountAsyncClient
extends AWSAccountClient
implements AWSAccountAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAccountAsyncClientBuilder asyncBuilder() {
        return AWSAccountAsyncClientBuilder.standard();
    }

    AWSAccountAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAccountAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteAlternateContactResult> deleteAlternateContactAsync(DeleteAlternateContactRequest request) {
        return this.deleteAlternateContactAsync(request, null);
    }

    @Override
    public Future<DeleteAlternateContactResult> deleteAlternateContactAsync(DeleteAlternateContactRequest request, final AsyncHandler<DeleteAlternateContactRequest, DeleteAlternateContactResult> asyncHandler) {
        final DeleteAlternateContactRequest finalRequest = (DeleteAlternateContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAlternateContactResult>(){

            @Override
            public DeleteAlternateContactResult call() throws Exception {
                DeleteAlternateContactResult result = null;
                try {
                    result = AWSAccountAsyncClient.this.executeDeleteAlternateContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAlternateContactResult> getAlternateContactAsync(GetAlternateContactRequest request) {
        return this.getAlternateContactAsync(request, null);
    }

    @Override
    public Future<GetAlternateContactResult> getAlternateContactAsync(GetAlternateContactRequest request, final AsyncHandler<GetAlternateContactRequest, GetAlternateContactResult> asyncHandler) {
        final GetAlternateContactRequest finalRequest = (GetAlternateContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAlternateContactResult>(){

            @Override
            public GetAlternateContactResult call() throws Exception {
                GetAlternateContactResult result = null;
                try {
                    result = AWSAccountAsyncClient.this.executeGetAlternateContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAlternateContactResult> putAlternateContactAsync(PutAlternateContactRequest request) {
        return this.putAlternateContactAsync(request, null);
    }

    @Override
    public Future<PutAlternateContactResult> putAlternateContactAsync(PutAlternateContactRequest request, final AsyncHandler<PutAlternateContactRequest, PutAlternateContactResult> asyncHandler) {
        final PutAlternateContactRequest finalRequest = (PutAlternateContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAlternateContactResult>(){

            @Override
            public PutAlternateContactResult call() throws Exception {
                PutAlternateContactResult result = null;
                try {
                    result = AWSAccountAsyncClient.this.executePutAlternateContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

