/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.transform.EbsSnapshotConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EbsSnapshotConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> userIds;
    private List<String> groups;
    private String kmsKeyId;

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new ArrayList<String>(userIds);
    }

    public EbsSnapshotConfiguration withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds(new ArrayList<String>(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add(ele);
        }
        return this;
    }

    public EbsSnapshotConfiguration withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<String>(groups);
    }

    public EbsSnapshotConfiguration withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public EbsSnapshotConfiguration withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public EbsSnapshotConfiguration withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserIds() != null) {
            sb.append("UserIds: ").append(this.getUserIds()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsSnapshotConfiguration)) {
            return false;
        }
        EbsSnapshotConfiguration other = (EbsSnapshotConfiguration)obj;
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        return other.getKmsKeyId() == null || other.getKmsKeyId().equals(this.getKmsKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        return hashCode;
    }

    public EbsSnapshotConfiguration clone() {
        try {
            return (EbsSnapshotConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsSnapshotConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

