/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.Trail;
import com.amazonaws.services.accessanalyzer.model.transform.CloudTrailDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CloudTrailDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessRole;
    private Date endTime;
    private Date startTime;
    private List<Trail> trails;

    public void setAccessRole(String accessRole) {
        this.accessRole = accessRole;
    }

    public String getAccessRole() {
        return this.accessRole;
    }

    public CloudTrailDetails withAccessRole(String accessRole) {
        this.setAccessRole(accessRole);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CloudTrailDetails withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public CloudTrailDetails withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    public void setTrails(Collection<Trail> trails) {
        if (trails == null) {
            this.trails = null;
            return;
        }
        this.trails = new ArrayList<Trail>(trails);
    }

    public CloudTrailDetails withTrails(Trail ... trails) {
        if (this.trails == null) {
            this.setTrails(new ArrayList<Trail>(trails.length));
        }
        for (Trail ele : trails) {
            this.trails.add(ele);
        }
        return this;
    }

    public CloudTrailDetails withTrails(Collection<Trail> trails) {
        this.setTrails(trails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessRole() != null) {
            sb.append("AccessRole: ").append(this.getAccessRole()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getTrails() != null) {
            sb.append("Trails: ").append(this.getTrails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudTrailDetails)) {
            return false;
        }
        CloudTrailDetails other = (CloudTrailDetails)obj;
        if (other.getAccessRole() == null ^ this.getAccessRole() == null) {
            return false;
        }
        if (other.getAccessRole() != null && !other.getAccessRole().equals(this.getAccessRole())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getTrails() == null ^ this.getTrails() == null) {
            return false;
        }
        return other.getTrails() == null || other.getTrails().equals(this.getTrails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessRole() == null ? 0 : this.getAccessRole().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrails() == null ? 0 : this.getTrails().hashCode());
        return hashCode;
    }

    public CloudTrailDetails clone() {
        try {
            return (CloudTrailDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudTrailDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

