/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.DeviceConfigurationType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class DeviceConfigurationTypeJsonUnmarshaller
implements Unmarshaller<DeviceConfigurationType, JsonUnmarshallerContext> {
    private static DeviceConfigurationTypeJsonUnmarshaller instance;

    DeviceConfigurationTypeJsonUnmarshaller() {
    }

    public DeviceConfigurationType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        DeviceConfigurationType deviceConfigurationType = new DeviceConfigurationType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("ChallengeRequiredOnNewDevice")) {
                deviceConfigurationType.setChallengeRequiredOnNewDevice(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeviceOnlyRememberedOnUserPrompt")) {
                deviceConfigurationType.setDeviceOnlyRememberedOnUserPrompt(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return deviceConfigurationType;
    }

    public static DeviceConfigurationTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceConfigurationTypeJsonUnmarshaller();
        }
        return instance;
    }
}

