/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import java.util.Map;

public class ForgotPasswordContinuation
implements CognitoIdentityProviderContinuation<CognitoUserCodeDeliveryDetails> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final ForgotPasswordHandler callback;
    private final CognitoUser user;
    private final CognitoUserCodeDeliveryDetails parameters;
    private final boolean runInBackground;
    private String password = null;
    private String verificationCode = null;
    private Map<String, String> clientMetadata;

    public ForgotPasswordContinuation(CognitoUser user, CognitoUserCodeDeliveryDetails parameters, boolean runInBackground, ForgotPasswordHandler callback) {
        this.callback = callback;
        this.user = user;
        this.parameters = parameters;
        this.runInBackground = runInBackground;
    }

    @Override
    public CognitoUserCodeDeliveryDetails getParameters() {
        return this.parameters;
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            this.user.confirmPasswordInBackground(this.verificationCode, this.password, this.clientMetadata, this.callback);
        } else {
            this.user.confirmPassword(this.verificationCode, this.password, this.clientMetadata, this.callback);
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }
}

