package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.util.IpUtil;

/**
 * WORKER_ID = <pid>_<timestamp%100000>
 *
 * @author xiaomeng.hxm
 */
public class WorkerIdGenerator {
    private static String WORKER_ID;

    public static String get() {
        if (WORKER_ID == null) {
            synchronized (WorkerIdGenerator.class) {
                if (WORKER_ID == null) {
                    WORKER_ID = IpUtil.getFormatIpv4Address() + "_" + SystemManagementUtil.getPid() + "_"
                        + System.currentTimeMillis() % 100000;
                }
            }
        }
        return WORKER_ID;
    }

    public static void main(String[] args) {
        System.out.println(get());
    }
}
