package com.alibaba.schedulerx.worker.timer;

import java.util.List;
import java.util.Random;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.util.ConsoleUtil;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * 如果云上环境，则从jmenv定期拉取domainName列表或console的vip server列表
 * 发现domainName变化了，则需要进行更新
 * @author zhaibian
 * @date 2019/04/03
 */
public class DomainNameUpdateTimer extends AbstractTimerTask{
    @Override
    public String getName() {
        return "DomainNameUpdateTimer";
    }

    @Override
    public long getInitialDelay() {
        return 5 * 60;
    }

    @Override
    public long getPeriod() {
        return 60;
    }

    @Override
    public void run() {
        // 如果指定domainName，不更新
        if (StringUtils.isNotBlank(
            System.getProperty(WorkerConstants.WORKER_DOMAIN_PROPERTY))) {
            return;
        }

        // 如果没有传地址服务器配置，不更新
        String addressServer = (String)ConfigUtil.getWorkerConfig().getProperty(WorkerConstants.ADDRESS_SERVER_DOMAIN);
        if (StringUtils.isBlank(addressServer)) {
            return;
        }

        String port = (String)ConfigUtil.getWorkerConfig().getProperty(WorkerConstants.ADDRESS_SERVER_PORT);
        List<String> vipList = ConsoleUtil.getVipServerList(addressServer, port);
        if (CollectionUtils.isEmpty(vipList)) {
            return;
        }

        String domainName = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_DOMAIN_NAME);
        if(vipList.contains(domainName)){
            return;
        }

        // 如果有多个，随机取一个
        int index = 0;
        if (vipList.size() > 1) {
            Random random = new Random();
            index = random.nextInt(vipList.size());
        }
        String temp = vipList.get(index);
        LOGGER.info("DomainName update. Change domain name [{}] to [{}].", domainName, temp);
        ConfigUtil.getWorkerConfig().setProperty(WorkerConstants.WORKER_DOMAIN_NAME, temp);
    }
}
