package com.alibaba.schedulerx.worker.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class DefaultAuthenticator implements Authenticator {
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
//    private long connectionTimeout = ConfigUtil.getWorkerConfig().getLong(WorkerConstants.WORKER_HTTP_CONNECTION_TIMEOUT, 
//            WorkerConstants.WORKER_HTTP_CONNECTION_TIMEOUT_DEFAULT);
    private static final Logger LOGGER = LogFactory.getLogger(DefaultAuthenticator.class); 

    @Override
    public void authenticate(Configuration conf, String namespace, String namespaceSource, List<String> groupIds) 
            throws AuthenticateException {
        JSONResult result = JSONResult.geneFailResult();
        
        // -Dschedulerx.appKey优先
        String appKeyProperty = System.getProperty(WorkerConstants.WORKER_APPKEY);
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty(WorkerConstants.APP_KEY, appKeyProperty);
        }
        
        String[] appKeys = conf.getStringArray(WorkerConstants.APP_KEY);
        if (appKeys.length <= 0) {
            throw new AuthenticateException("please set appKey for groupId=" + groupIds);
        }
        Map<String, Object> parameterMap = new HashMap<>();
        if (StringUtils.isNotBlank(namespace)) {
            parameterMap.put("namespace", namespace);
        }
        if (StringUtils.isNotBlank(namespaceSource)) {
            parameterMap.put("namespaceSource", namespaceSource);
        }
        parameterMap.put("groups", StringUtils.join(groupIds,","));
        parameterMap.put("accessKey", StringUtils.join(appKeys,","));
        parameterMap.put("type", "authenticate_default");
        String domain = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_DOMAIN_NAME);
        if (StringUtils.isNotBlank(domain)) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
//                Unirest.setTimeouts(connectionTimeout, 60000);
                HttpResponse<JsonNode> jsonResponse = Unirest.post(url).fields(parameterMap).asJson();
                if (jsonResponse != null) {
                    result = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            } catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            } catch (Exception e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
        }
        
        if (result != null) {
            if (!result.isSuccess() || !(Boolean)result.getData()) {
                throw new AuthenticateException(result.getMessage());
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
        
    }
}
