package com.alibaba.schedulerx.worker.pull;

import java.util.List;

import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.batch.TaskDispatchReqHandler;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;

/**
 *
 * @author xiaomeng.hxm
 */
public class TaskPullReqHandler<T> extends TaskDispatchReqHandler<T>{

    public TaskPullReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize,
            ReqQueue<T> queue) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue,
        "Schedulerx-Batch-Tasks-Pull-Thread-", "Schedulerx-Batch-Tasks-Retrieve-Thread-");
    }

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerIdAddr) {
        ((MapTaskMaster)taskMasterPool.get(jobInstanceId)).batchPullTasks(
                (List<MasterStartContainerRequest>)reqs, workerIdAddr);
    }

}
