package com.alibaba.schedulerx.worker.processor.demo;

import java.util.List;

import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 *
 * @author zhaibian
 */
@Component
public class TestParallelJobProcessor extends MapJobProcessor {
    private static final Logger LOGGER                = LogFactory.getLogger(TestParallelJobProcessor.class);
    private static final String FIRST_LEVEL_DISPATCH  = "FIRST_LEVEL_DISPATCH";

    @Override
    public ProcessResult process(JobContext context) {
        String taskName = context.getTaskName();

        if (WorkerConstants.MAP_TASK_ROOT_NAME.equals(taskName)) {
            LOGGER.info("[TestParallelJobProcessor] Start root task.");
            LOGGER.info("jobId={}, jobInstanceId={}, jobParameters={}, instanceParameters={}",
                    context.getJobId(), context.getJobInstanceId(), context.getJobParameters(),
                    context.getInstanceParameters());
            List<TestTaskObject> tasks = buildFirstLevelDispatchTasks();
            // this just for demo
            if (CollectionUtils.isEmpty(tasks)) {
                return new ProcessResult(true);
            }

            return map(tasks, FIRST_LEVEL_DISPATCH);
        } else if (FIRST_LEVEL_DISPATCH.equals(taskName)) {
            LOGGER.info("[TestParallelJobProcessor] Start FIRST_LEVEL_DISPATCH task.");

            TestTaskObject taskObject = (TestTaskObject) context.getTask();
            LOGGER.info("TestTaskObject={}", taskObject);

            return new ProcessResult(true);
        }

        return new ProcessResult(false);
    }

    /**
     * build first level dispatch task list
     * @return
     */
    private List<TestTaskObject> buildFirstLevelDispatchTasks() {
        List<TestTaskObject> tasks = Lists.newArrayList();

        for (int i = 0; i <= 100; i++) {
            tasks.add(new TestTaskObject(i, "Hello SchedulerX2.0! This is [TestParallelJobProcessor] msg_" + i));
        }

        return tasks;
    }

}
