package com.alibaba.schedulerx.worker.logcollector;

import org.apache.commons.lang.StringUtils;

/**
 * 客户端日志记录
 *
 * @author 陆昆
 * @create 2018-12-10 下午8:38
 **/
public class ClientLoggerMessage {
    public static final String INSTANCE_TRIGGER_SUCCESS = "[JobInstanceActor-handleSubmitJobInstance]server trigger client success.";

    public static final String INSTANCE_TRIGGER_FAIL = "[JobInstanceActor-handleSubmitJobInstance]server trigger client fail.";
    
    public static final String INSTANCE_INIT_FAIL = "[MapTaskMaster-submitInstance]instance init fail.";

    public static final String INSTANCE_FINISH = "[TaskMaster-updateTaskStatus]instance finish status is ";

    public static final String INSTANCE_KILL_START_SUCCESS = "[JobInstanceActor-handleKillJobInstance]server kill instance start success.";

    public static final String INSTANCE_KILL_START_FAIL = "[JobInstanceActor-handleKillJobInstance]server kill instance start fail.";

    public static final String CONTAINER_START_FAIL = "[ContainerActor-handleStartContainer]container start instance fail.";

    public static final String CONTAINER_KILL_SUCCESS = "[ContainerActor-handleKillContainer]container kill instance success.";

    public static final String CONTAINER_KILL_FAIL = "[ContainerActor-handleKillContainer]container kill instance fail.";

    public static final String JOB_PROCESSOR_EXEC_FAIL = "[ThreadContainer-run]job processor exec fail.";

    public static final String STANDALONE_INSTANCE_INIT_SUCCESS = "[StandaloneTaskMaster-submitTask]standalone task init success.";

    public static final String STANDALONE_INSTANCE_INIT_FAIL = "[StandaloneTaskMaster-submitTask]standalone task init fail. ";

    public static final String BROADCAST_INSTANCE_INIT_SUCCESS = "[BroadcastTaskMaster-submitTask]broadcast task init success worker addr is ";

    public static final String BROADCAST_INSTANCE_INIT_FAIL = "[BroadcastTaskMaster-submitTask]broadcast task init fail worker addr is ";

    public static final String INSTANCE_KILL_FAIL = "[Master-killInstance]kill instance tell worker fail worker addr is ";

    public static final String MAP_INSTANCE_FAIL = "[MapTaskMaster-init]map task init fail.";

    public static final String MAP_CREATE_TASK_FAIL = "[TaskCreateReqHandler-create]create task fail size ";

    public static final String MAP_INSTANCE_PULL_JOB_FAIL = "[MapTaskMaster-init-pull]map task pull fail.";

    public static final String MAP_INSTANCE_DISPATCH_JOB_FAIL = "[MapTaskMaster-init-dispatch]map task dispatch fail.";

    public static String appendMessage(String baseMessage,  String... appendMessages) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(baseMessage)) {
            sb.append(baseMessage);
            if (appendMessages != null) {
                for (String appendMessage : appendMessages) {
                    sb.append(appendMessage);
                }
            }
        }
        return sb.toString();
    }
}
