package com.alibaba.schedulerx.worker.log;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.schedulerx.worker.log.factory.Log4j2LoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.Log4jLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.LogbackLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.NopLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.SchedulerxLoggerFactory;

/**
 * @author zhaibian
 * @version $Id: LogFactory.java, v 0.1 2019年01月08日 15:53 zhaibian Exp $
 */
public class LogFactory {
    private static SchedulerxLoggerFactory LOGGER_FACTORY;
    private static Map<String, Logger> loggerCache;

    public static Logger getLogger(String name) {
        Logger logger = loggerCache.get(name);
        if (logger == null) {
            synchronized (LOGGER_FACTORY) {
                logger = loggerCache.get(name);
                if (logger == null) {
                    logger = LOGGER_FACTORY.getLogger(name);
                    loggerCache.put(name, logger);
                }
            }
        }

        return logger;
    }

    public static Logger getLogger(Class clazz) {
        return getLogger(clazz.getName());
    }

    private static void println(String msg){
        System.out.println(msg);
    }

    // 查找常用的日志框架
    static {
        try {
            LOGGER_FACTORY = new Log4j2LoggerFactory();
            println(
                "Schedulerx init JM logger with Log4j2LoggerFactory success, " + LogFactory.class.getClassLoader());
        } catch (Throwable e1) {
            try {
                LOGGER_FACTORY = new Log4jLoggerFactory();
                println(
                    "Schedulerx init JM logger with Log4jLoggerFactory success, " + LogFactory.class.getClassLoader());
            } catch (Throwable e2) {
                try {
                    LOGGER_FACTORY = new LogbackLoggerFactory();
                    println("Schedulerx init JM logger with LogbackLoggerFactory success, "
                            + LogFactory.class.getClassLoader());
                } catch (Throwable e3) {
                    LOGGER_FACTORY = new NopLoggerFactory();
                    println("Schedulerx init JM logger with NopLoggerFactory, pay attention. "
                        + LogFactory.class.getClassLoader());
                }
            }
        }

        loggerCache = new ConcurrentHashMap<>();
    }
}