package com.alibaba.schedulerx.worker.discovery;

import java.io.IOException;
import java.util.Map;

import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.ConsoleUtil;

import akka.actor.ActorSystem;
import com.google.common.collect.Maps;

public enum GroupManager {
    INSTANCE;
    
    private String namespace;
    private String namespaceSource;
    
    private Map<String, Long> groupId2AppGroupIdMap = Maps.newConcurrentMap();
    private Map<String, Integer> parentGroupId2CountMap = Maps.newConcurrentMap();
    
    private static final Logger LOGGER = LogFactory.getLogger(SchedulerxWorker.class);
    
    public void init(String namespace, String namespaceSource) {
        this.namespace = namespace;
        this.namespaceSource = namespaceSource;
    }
    
    public int getCountByParentGroupId(String parentGroupId) {
        if (parentGroupId2CountMap.containsKey(parentGroupId)) {
            return parentGroupId2CountMap.get(parentGroupId);
        } else {
            return 0;
        }
    }
    
    public boolean contains(String groupId) {
        return groupId2AppGroupIdMap.containsKey(groupId);
    }
    
    public void appendGroupId(String groupId, String parentGroupId) throws IOException {
        long appGroupId = ConsoleUtil.getAppGroupId(groupId, namespace, namespaceSource);
        if (appGroupId <= 0) {
            throw new IOException("groupId=" + groupId + " is not exist, namespace=" + namespace);
        }
        groupId2AppGroupIdMap.put(groupId, appGroupId);
        
        if (parentGroupId2CountMap.containsKey(parentGroupId)) {
            int count = parentGroupId2CountMap.get(parentGroupId);
            parentGroupId2CountMap.put(parentGroupId, count+1);
        } else {
            parentGroupId2CountMap.put(parentGroupId, 1);
        }
    }
    
    public Map<String, Long> getGroupId2AppGroupIdMap() {
        return groupId2AppGroupIdMap;
    }
    
    public void startServerDiscovery(String groupId) throws Exception {
        ServerDiscovery discovery = ServerDiscoveryFactory.getDiscovery(groupId);
        discovery.start(namespace, namespaceSource, groupId);
    }
    
    public void reset(ActorSystem actorSystem) throws Exception {
        for (String groupId : groupId2AppGroupIdMap.keySet()) {
            ServerDiscovery discovery = ServerDiscoveryFactory.getDiscovery(groupId);
            discovery.reset(actorSystem);
        }
//        ServerDiscoveryFactory.clear();
//        for (String groupId : groupId2AppGroupIdMap.keySet()) {
//            startServerDiscovery(groupId);
//        }
        
    }
}
