package com.alibaba.schedulerx.worker.batch;

import java.util.List;

import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;

/**
 * Task master Batch dispatch tasks to workers
 * @author yanxun on 2019/1/6.
 */
public class TaskPushReqHandler<T> extends TaskDispatchReqHandler<T> {
    private int dispatchSize;
    private static final Logger LOGGER = LogFactory.getLogger(TaskPushReqHandler.class);

    public TaskPushReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize,
                                  ReqQueue<T> queue, int dispatchSize) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue,
            "Schedulerx-Batch-Tasks-Dispatch-Thread-", "Schedulerx-Batch-Tasks-Retrieve-Thread-");
        defaultSleepMs = 100;
        this.dispatchSize = dispatchSize;
    }

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
        batchProcessSvc.submit(new BatchTasksDispatchRunnable(jobInstanceId, (List<MasterStartContainerRequest>) reqs));
    }

    private class BatchTasksDispatchRunnable implements Runnable {
        private long jobInstanceId;
        private List<MasterStartContainerRequest> reqs;
        BatchTasksDispatchRunnable(long jobInstanceId, List<MasterStartContainerRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.reqs = reqs;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                ((MapTaskMaster)taskMasterPool.get(jobInstanceId)).batchDispatchTasks(reqs);
                LOGGER.info("jobInstance={}, batch dispatch cost:{} ms, dispatchSize:{}, size:{}",
                    jobInstanceId, System.currentTimeMillis() - startTime, dispatchSize, reqs.size());
            } catch (Throwable e) {
                LOGGER.error(e);
            } finally {
                activeRunnableNum.decrementAndGet();
            }
        }
    }

}
