package com.alibaba.schedulerx.worker.actor.routing;

import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import akka.routing.Routee;
import akka.routing.RoutingLogic;
import scala.collection.immutable.IndexedSeq;

/**
 *
 * @author xiaomeng.hxm
 */
public class InstanceRoutingLogic implements RoutingLogic {
    private static final Logger LOGGER = LogFactory.getLogger(InstanceRoutingLogic.class);

    @Override
    public Routee select(Object obj, IndexedSeq<Routee> routees) {
        try {
            long jobInstanceId = (long) ReflectionUtil.invokeMethod(obj, "getJobInstanceId");
            int index = (int)(jobInstanceId % routees.size());
            return routees.apply(index);
        } catch (Throwable e) {
            LOGGER.error("", e);
        }
        return null;
    }

}
