package com.alibaba.schedulerx.worker.actor;

import java.util.List;

import com.alibaba.schedulerx.common.domain.TaskDispatchMode;
import com.alibaba.schedulerx.protocol.Worker.ContainerCheckZombieRequest;
import com.alibaba.schedulerx.protocol.Worker.ContainerCheckZombieResponse;
import com.alibaba.schedulerx.protocol.Worker.MasterCheckWorkerAliveRequest;
import com.alibaba.schedulerx.protocol.Worker.MasterCheckWorkerAliveResponse;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.pull.PullManager;

import akka.actor.UntypedActor;
import com.google.common.collect.Lists;

/**
 * @author yanxun on 2019/1/9.
 */
public class WorkerHeartbeatActor extends UntypedActor{
    private TaskMasterPool taskMasterPool = TaskMasterPool.INSTANCE;

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof MasterCheckWorkerAliveRequest) {
            handleCheckWorkerAlive((MasterCheckWorkerAliveRequest) obj);
        } else if (obj instanceof ContainerCheckZombieRequest) {
            handleCheckZombie((ContainerCheckZombieRequest) obj);
        }
    }

    private void handleCheckWorkerAlive(MasterCheckWorkerAliveRequest request) {
        MasterCheckWorkerAliveResponse response;
        long jobInstanceId = request.getJobInstanceId();
        if (request.hasDispatchMode() &&
                request.getDispatchMode().equals(TaskDispatchMode.PULL.getValue()) &&
                PullManager.INSTANCE.contains(jobInstanceId) &&
                PullManager.INSTANCE.isCrashed(jobInstanceId)) {
            response = MasterCheckWorkerAliveResponse.newBuilder()
                    .setSuccess(false)
                    .setMessage(request.getJobInstanceId() + "  is crashed in PullMananger")
                    .build();
        } else {
            response = MasterCheckWorkerAliveResponse.newBuilder().setSuccess(true).build();
        }
        getSender().tell(response, getSelf());
    }

    private void handleCheckZombie(ContainerCheckZombieRequest request) {
        List<Long> zombieJobInstanceIds = Lists.newArrayList();
        ContainerCheckZombieResponse response;
        for (Long jobInstanceId : request.getJobInstanceIdList()) {
            if (!taskMasterPool.contains(jobInstanceId)) {
                zombieJobInstanceIds.add(jobInstanceId);
            }
        }
        response = ContainerCheckZombieResponse.newBuilder()
            .addAllZombieJobInstanceId(zombieJobInstanceIds)
            .build();
        getSender().tell(response, getSelf());
    }
}
