/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ClientAuth;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSsl;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContextBuilder;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslProvider;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Properties;

public class TlsHelper {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static DecryptionStrategy decryptionStrategy = new DecryptionStrategy(){

        @Override
        public InputStream decryptPrivateKey(String privateKeyEncryptPath, boolean forClient) throws IOException {
            return new FileInputStream(privateKeyEncryptPath);
        }
    };

    public static void registerDecryptionStrategy(DecryptionStrategy decryptionStrategy) {
        TlsHelper.decryptionStrategy = decryptionStrategy;
    }

    public static SslContext buildSslContext(boolean forClient) throws IOException, CertificateException {
        SslProvider provider;
        File configFile = new File(TlsSystemConfig.tlsConfigFile);
        TlsHelper.extractTlsConfigFromFile(configFile);
        TlsHelper.logTheFinalUsedTlsConfig();
        if (OpenSsl.isAvailable()) {
            provider = SslProvider.OPENSSL;
            LOGGER.info("Using OpenSSL provider");
        } else {
            provider = SslProvider.JDK;
            LOGGER.info("Using JDK SSL provider");
        }
        if (forClient) {
            if (TlsSystemConfig.tlsTestModeEnable) {
                return SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
            if (!TlsSystemConfig.tlsClientAuthServer) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (!TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsClientTrustCertPath)) {
                sslContextBuilder.trustManager(new File(TlsSystemConfig.tlsClientTrustCertPath));
            }
            return sslContextBuilder.keyManager(!TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsClientCertPath) ? new FileInputStream(TlsSystemConfig.tlsClientCertPath) : null, !TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsClientKeyPath) ? decryptionStrategy.decryptPrivateKey(TlsSystemConfig.tlsClientKeyPath, true) : null, !TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsClientKeyPassword) ? TlsSystemConfig.tlsClientKeyPassword : null).build();
        }
        if (TlsSystemConfig.tlsTestModeEnable) {
            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
            return SslContextBuilder.forServer(selfSignedCertificate.certificate(), selfSignedCertificate.privateKey()).sslProvider(SslProvider.JDK).clientAuth(ClientAuth.OPTIONAL).build();
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(!TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsServerCertPath) ? new FileInputStream(TlsSystemConfig.tlsServerCertPath) : null, !TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsServerKeyPath) ? decryptionStrategy.decryptPrivateKey(TlsSystemConfig.tlsServerKeyPath, false) : null, !TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsServerKeyPassword) ? TlsSystemConfig.tlsServerKeyPassword : null).sslProvider(provider);
        if (!TlsSystemConfig.tlsServerAuthClient) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (!TlsHelper.isNullOrEmpty(TlsSystemConfig.tlsServerTrustCertPath)) {
            sslContextBuilder.trustManager(new File(TlsSystemConfig.tlsServerTrustCertPath));
        }
        sslContextBuilder.clientAuth(TlsHelper.parseClientAuthMode(TlsSystemConfig.tlsServerNeedClientAuth));
        return sslContextBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractTlsConfigFromFile(File configFile) {
        if (!(configFile.exists() && configFile.isFile() && configFile.canRead())) {
            LOGGER.info("Tls config file doesn't exist, skip it");
            return;
        }
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            properties.load(inputStream);
        }
        catch (IOException ignore) {
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ignore) {}
            }
        }
        TlsSystemConfig.tlsTestModeEnable = Boolean.parseBoolean(properties.getProperty("tls.test.mode.enable", String.valueOf(TlsSystemConfig.tlsTestModeEnable)));
        TlsSystemConfig.tlsServerNeedClientAuth = properties.getProperty("tls.server.need.client.auth", TlsSystemConfig.tlsServerNeedClientAuth);
        TlsSystemConfig.tlsServerKeyPath = properties.getProperty("tls.server.keyPath", TlsSystemConfig.tlsServerKeyPath);
        TlsSystemConfig.tlsServerKeyPassword = properties.getProperty("tls.server.keyPassword", TlsSystemConfig.tlsServerKeyPassword);
        TlsSystemConfig.tlsServerCertPath = properties.getProperty("tls.server.certPath", TlsSystemConfig.tlsServerCertPath);
        TlsSystemConfig.tlsServerAuthClient = Boolean.parseBoolean(properties.getProperty("tls.server.authClient", String.valueOf(TlsSystemConfig.tlsServerAuthClient)));
        TlsSystemConfig.tlsServerTrustCertPath = properties.getProperty("tls.server.trustCertPath", TlsSystemConfig.tlsServerTrustCertPath);
        TlsSystemConfig.tlsClientKeyPath = properties.getProperty("tls.client.keyPath", TlsSystemConfig.tlsClientKeyPath);
        TlsSystemConfig.tlsClientKeyPassword = properties.getProperty("tls.client.keyPassword", TlsSystemConfig.tlsClientKeyPassword);
        TlsSystemConfig.tlsClientCertPath = properties.getProperty("tls.client.certPath", TlsSystemConfig.tlsClientCertPath);
        TlsSystemConfig.tlsClientAuthServer = Boolean.parseBoolean(properties.getProperty("tls.client.authServer", String.valueOf(TlsSystemConfig.tlsClientAuthServer)));
        TlsSystemConfig.tlsClientTrustCertPath = properties.getProperty("tls.client.trustCertPath", TlsSystemConfig.tlsClientTrustCertPath);
    }

    private static void logTheFinalUsedTlsConfig() {
        LOGGER.info("Log the final used tls related configuration");
        LOGGER.info("{} = {}", (Object)"tls.test.mode.enable", (Object)TlsSystemConfig.tlsTestModeEnable);
        LOGGER.info("{} = {}", (Object)"tls.server.need.client.auth", (Object)TlsSystemConfig.tlsServerNeedClientAuth);
        LOGGER.info("{} = {}", (Object)"tls.server.keyPath", (Object)TlsSystemConfig.tlsServerKeyPath);
        LOGGER.info("{} = {}", (Object)"tls.server.keyPassword", (Object)TlsSystemConfig.tlsServerKeyPassword);
        LOGGER.info("{} = {}", (Object)"tls.server.certPath", (Object)TlsSystemConfig.tlsServerCertPath);
        LOGGER.info("{} = {}", (Object)"tls.server.authClient", (Object)TlsSystemConfig.tlsServerAuthClient);
        LOGGER.info("{} = {}", (Object)"tls.server.trustCertPath", (Object)TlsSystemConfig.tlsServerTrustCertPath);
        LOGGER.info("{} = {}", (Object)"tls.client.keyPath", (Object)TlsSystemConfig.tlsClientKeyPath);
        LOGGER.info("{} = {}", (Object)"tls.client.keyPassword", (Object)TlsSystemConfig.tlsClientKeyPassword);
        LOGGER.info("{} = {}", (Object)"tls.client.certPath", (Object)TlsSystemConfig.tlsClientCertPath);
        LOGGER.info("{} = {}", (Object)"tls.client.authServer", (Object)TlsSystemConfig.tlsClientAuthServer);
        LOGGER.info("{} = {}", (Object)"tls.client.trustCertPath", (Object)TlsSystemConfig.tlsClientTrustCertPath);
    }

    private static ClientAuth parseClientAuthMode(String authMode) {
        if (null == authMode || authMode.trim().isEmpty()) {
            return ClientAuth.NONE;
        }
        for (ClientAuth clientAuth : ClientAuth.values()) {
            if (!clientAuth.name().equals(authMode.toUpperCase())) continue;
            return clientAuth;
        }
        return ClientAuth.NONE;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static interface DecryptionStrategy {
        public InputStream decryptPrivateKey(String var1, boolean var2) throws IOException;
    }
}

