/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.metrics;

import com.aliyun.openservices.shade.io.prometheus.client.Collector;
import com.aliyun.openservices.shade.io.prometheus.client.CollectorRegistry;
import com.aliyun.openservices.shade.io.prometheus.client.Counter;
import com.aliyun.openservices.shade.io.prometheus.client.Gauge;
import com.aliyun.openservices.shade.io.prometheus.client.Histogram;
import com.aliyun.openservices.shade.io.prometheus.client.Summary;
import com.aliyun.openservices.shade.io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MetricsUtils {
    public static final CollectorRegistry REGISTRY = new CollectorRegistry();
    private static final ConcurrentMap<String, Collector> COLLECTOR_MAP = new ConcurrentHashMap<String, Collector>();
    private static final LinkedHashSet<String> TOKENS = new LinkedHashSet();
    public static final int COMPRESSION_MIN_SIZE = 10000;
    private static final int TOKEN_MAX_NUM = 100;
    private static final double[] BUCKETS = new double[]{0.001, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 30.0, 60.0};

    public static String[] labels2StringArray(Set<String> labels) {
        return labels.toArray(new String[labels.size()]);
    }

    public static String[] values2StringArray(ArrayList<String> values) {
        return values.toArray(new String[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addTokens(String token) {
        if (TOKENS.contains(token)) {
            return false;
        }
        LinkedHashSet<String> linkedHashSet = TOKENS;
        synchronized (linkedHashSet) {
            TOKENS.add(token);
            int tokenSize = TOKENS.size();
            int needDeletedNum = tokenSize - 100;
            Iterator it = TOKENS.iterator();
            while (it.hasNext() && needDeletedNum-- > 0) {
                it.remove();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Collector registerMetricsCollector(Class<T> clazz, String name, TreeSet<String> labels, String help) throws Exception {
        Collector collector = (Collector)COLLECTOR_MAP.get(name);
        if (collector == null) {
            Class<MetricsUtils> clazz2 = MetricsUtils.class;
            synchronized (MetricsUtils.class) {
                block11: {
                    try {
                        Collector oldCollector = (Collector)COLLECTOR_MAP.get(name);
                        if (oldCollector != null) {
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                            return oldCollector;
                        }
                        if (clazz == Counter.class) {
                            collector = ((Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(MetricsUtils.labels2StringArray(labels))).name(name)).help(help)).register(REGISTRY)).register();
                            break block11;
                        }
                        if (clazz == Gauge.class) {
                            collector = ((Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().labelNames(MetricsUtils.labels2StringArray(labels))).name(name)).help(help)).register(REGISTRY)).register();
                            break block11;
                        }
                        if (clazz == Histogram.class) {
                            collector = ((Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(BUCKETS).labelNames(MetricsUtils.labels2StringArray(labels))).name(name)).help(help)).register(REGISTRY)).register();
                            break block11;
                        }
                        if (clazz == Summary.class) {
                            collector = ((Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().labelNames(MetricsUtils.labels2StringArray(labels))).name(name)).help(help)).register(REGISTRY)).register();
                            break block11;
                        }
                        throw new Exception("Wrong metrics type: " + clazz.getName());
                    }
                    catch (Exception e) {
                        throw new Exception(String.format("Register metrics failed, metrics name: %s, metrics type: %s", name, clazz.getName()));
                    }
                }
                COLLECTOR_MAP.putIfAbsent(name, collector);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return collector;
            }
        }
        return collector;
    }

    public static Counter.Child getCounter(String name, TreeMap<String, String> labelValues, String help) throws Exception {
        Collector collector = MetricsUtils.registerMetricsCollector(Counter.class, name, new TreeSet<String>(labelValues.keySet()), help);
        if (!(collector instanceof Counter)) {
            throw new Exception("Metrics type not match, needed type: Counter");
        }
        Counter counter = (Counter)collector;
        return (Counter.Child)counter.labels(MetricsUtils.values2StringArray(new ArrayList<String>(labelValues.values())));
    }

    public static Gauge.Child getGauge(String name, TreeMap<String, String> labelValues, String help) throws Exception {
        Collector collector = MetricsUtils.registerMetricsCollector(Gauge.class, name, new TreeSet<String>(labelValues.keySet()), help);
        if (!(collector instanceof Gauge)) {
            throw new Exception("Metrics type not match, needed type: Gauge");
        }
        Gauge gauge = (Gauge)collector;
        return (Gauge.Child)gauge.labels(MetricsUtils.values2StringArray(new ArrayList<String>(labelValues.values())));
    }

    public static Summary.Child getSummary(String name, TreeMap<String, String> labelValues, String help) throws Exception {
        Collector collector = MetricsUtils.registerMetricsCollector(Summary.class, name, new TreeSet<String>(labelValues.keySet()), help);
        if (!(collector instanceof Summary)) {
            throw new Exception("Metrics type not match, needed type: Summary");
        }
        Summary summary = (Summary)collector;
        return (Summary.Child)summary.labels(MetricsUtils.values2StringArray(new ArrayList<String>(labelValues.values())));
    }

    public static Histogram.Child getHistogram(String name, TreeMap<String, String> labelValues, String help) throws Exception {
        Collector collector = MetricsUtils.registerMetricsCollector(Histogram.class, name, new TreeSet<String>(labelValues.keySet()), help);
        if (!(collector instanceof Histogram)) {
            throw new Exception("Metrics type not match, needed type: Histogram");
        }
        Histogram histogram = (Histogram)collector;
        return (Histogram.Child)histogram.labels(MetricsUtils.values2StringArray(new ArrayList<String>(labelValues.values())));
    }

    public static String metrics2String() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(stream);
        TextFormat.write004(osw, REGISTRY.filteredMetricFamilySamples(new HashSet<String>()));
        osw.flush();
        osw.close();
        return new String(stream.toByteArray());
    }
}

