/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.CommonConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class ConfigInputDetail
extends CommonConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = 8699540049365755476L;
    private String filePattern = "";
    private ArrayList<String> key = new ArrayList();
    private String logBeginRegex = "";
    private String logPath = "";
    private String regex = "";
    private String timeFormat = "";
    private ArrayList<String> filterRegex = new ArrayList();
    private ArrayList<String> filterKey = new ArrayList();
    private String topicFormat = "none";

    public ConfigInputDetail(String logPath, String filePattern, String logType, String logBeginRegex, String regex, ArrayList<String> key, String timeFormat, boolean localStorage) {
        this.logPath = logPath;
        this.filePattern = filePattern;
        this.logType = logType;
        this.logBeginRegex = logBeginRegex;
        this.regex = regex;
        this.SetKey(key);
        this.timeFormat = timeFormat;
        this.localStorage = localStorage;
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"filePattern", (Object)this.filePattern);
        JSONArray keyArray = new JSONArray();
        for (String string : this.key) {
            keyArray.add((Object)string);
        }
        jsonObj.put((Object)"key", (Object)keyArray);
        jsonObj.put((Object)"localStorage", (Object)this.localStorage);
        jsonObj.put((Object)"logBeginRegex", (Object)this.logBeginRegex);
        jsonObj.put((Object)"logPath", (Object)this.logPath);
        jsonObj.put((Object)"logType", (Object)this.logType);
        jsonObj.put((Object)"regex", (Object)this.regex);
        jsonObj.put((Object)"timeFormat", (Object)this.timeFormat);
        JSONArray filterRegexArray = new JSONArray();
        for (String fr : this.filterRegex) {
            filterRegexArray.add((Object)fr);
        }
        jsonObj.put((Object)"filterRegex", (Object)filterRegexArray);
        JSONArray jSONArray = new JSONArray();
        for (String fk : this.filterKey) {
            jSONArray.add((Object)fk);
        }
        jsonObj.put((Object)"filterKey", (Object)jSONArray);
        jsonObj.put((Object)"topicFormat", (Object)this.topicFormat);
        return jsonObj;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    @Override
    public void FromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.filePattern = inputDetail.getString("filePattern");
            this.SetKey(inputDetail.getJSONArray("key"));
            this.localStorage = inputDetail.getBoolean("localStorage");
            this.logBeginRegex = inputDetail.getString("logBeginRegex");
            this.logPath = inputDetail.getString("logPath");
            this.logType = inputDetail.getString("logType");
            this.regex = inputDetail.getString("regex");
            this.timeFormat = inputDetail.getString("timeFormat");
            this.SetFilterRegex(inputDetail.getJSONArray("filterRegex"));
            this.SetFilterKey(inputDetail.getJSONArray("filterKey"));
            this.topicFormat = inputDetail.getString("topicFormat");
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String inputDetailString) throws LogException {
        try {
            JSONObject inputDetail = JSONObject.fromObject((Object)inputDetailString);
            this.FromJsonObject(inputDetail);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public ConfigInputDetail() {
    }

    public ConfigInputDetail(ConfigInputDetail inputDetail) {
        this.filePattern = inputDetail.GetFilePattern();
        this.SetKey(inputDetail.GetKey());
        this.localStorage = inputDetail.GetLocalStorage();
        this.logBeginRegex = inputDetail.GetLogBeginRegex();
        this.logPath = inputDetail.GetLogPath();
        this.logType = inputDetail.GetLogType();
        this.regex = inputDetail.GetRegex();
        this.timeFormat = inputDetail.GetTimeFormat();
        this.SetFilterKeyRegex(inputDetail.GetFilterKey(), inputDetail.GetFilterRegex());
        this.topicFormat = inputDetail.GetTopicFormat();
    }

    public String GetFilePattern() {
        return this.filePattern;
    }

    public void SetFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public ArrayList<String> GetKey() {
        return this.key;
    }

    public void SetKey(ArrayList<String> key) {
        this.key = new ArrayList<String>(key);
    }

    public void SetKey(JSONArray key) throws LogException {
        try {
            this.key = new ArrayList();
            for (int i = 0; i < key.size(); ++i) {
                this.key.add(key.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetKey", e.getMessage(), e, "");
        }
    }

    public boolean GetLocalStorage() {
        return this.localStorage;
    }

    public void SetLocalStorage(boolean localStorage) {
        this.localStorage = localStorage;
    }

    public String GetLogBeginRegex() {
        return this.logBeginRegex;
    }

    public void SetLogBeginRegex(String logBeginRegex) {
        this.logBeginRegex = logBeginRegex;
    }

    public String GetLogPath() {
        return this.logPath;
    }

    public void SetLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String GetLogType() {
        return this.logType;
    }

    public void SetLogType(String logType) {
        this.logType = logType;
    }

    public String GetRegex() {
        return this.regex;
    }

    public void SetRegex(String regex) {
        this.regex = regex;
    }

    public String GetTimeFormat() {
        return this.timeFormat;
    }

    public void SetTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public ArrayList<String> GetFilterRegex() {
        return this.filterRegex;
    }

    public void SetFilterKeyRegex(List<String> filterKey, List<String> filterRegex) {
        this.filterKey = new ArrayList<String>(filterKey);
        this.filterRegex = new ArrayList<String>(filterRegex);
    }

    public void SetFilterRegex(JSONArray filterRegex) throws LogException {
        try {
            this.filterRegex = new ArrayList();
            for (int i = 0; i < filterRegex.size(); ++i) {
                this.filterRegex.add(filterRegex.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterRegex", e.getMessage(), e, "");
        }
    }

    public ArrayList<String> GetFilterKey() {
        return this.filterKey;
    }

    public void SetFilterKey(JSONArray filterKey) throws LogException {
        try {
            this.filterKey = new ArrayList();
            for (int i = 0; i < filterKey.size(); ++i) {
                this.filterKey.add(filterKey.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterKey", e.getMessage(), e, "");
        }
    }

    public String GetTopicFormat() {
        return this.topicFormat;
    }

    public void SetTopicFormat(String topicFormat) {
        this.topicFormat = topicFormat;
    }
}

