/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.triple;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.interceptor.ClientHeaderClientInterceptor;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.triple.ReferenceCountManagedChannel;
import com.alipay.sofa.rpc.transport.triple.TripleClientInvoker;
import com.alipay.sofa.rpc.transport.triple.TripleInvoker;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

@Extension(value="tri")
public class TripleClientTransport
extends ClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleClientTransport.class);
    protected ProviderInfo providerInfo;
    protected ManagedChannel channel;
    protected InetSocketAddress localAddress;
    protected InetSocketAddress remoteAddress;
    protected TripleInvoker tripleClientInvoker;
    protected static final ConcurrentMap<String, ReferenceCountManagedChannel> channelMap = new ConcurrentHashMap<String, ReferenceCountManagedChannel>();
    protected final Object lock = new Object();

    public TripleClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
        this.providerInfo = transportConfig.getProviderInfo();
        this.connect();
        this.remoteAddress = InetSocketAddress.createUnresolved(this.providerInfo.getHost(), this.providerInfo.getPort());
        this.localAddress = InetSocketAddress.createUnresolved(NetUtils.getLocalIpv4(), 0);
    }

    @Override
    public void connect() {
        if (this.isAvailable()) {
            return;
        }
        ProviderInfo providerInfo = this.transportConfig.getProviderInfo();
        this.channel = this.getSharedChannel(providerInfo);
        this.tripleClientInvoker = this.buildClientInvoker();
    }

    protected TripleClientInvoker buildClientInvoker() {
        return new TripleClientInvoker(this.transportConfig.getConsumerConfig(), (Channel)this.channel);
    }

    @Override
    public void disconnect() {
        if (this.channel != null) {
            try {
                this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Triple channel shut down interrupted.");
            }
            this.channel = null;
        }
        channelMap.remove(this.providerInfo.toString());
    }

    @Override
    public void destroy() {
        this.disconnect();
    }

    @Override
    public boolean isAvailable() {
        return this.channelAvailable(this.channel);
    }

    protected boolean channelAvailable(ManagedChannel channel) {
        if (channel == null) {
            return false;
        }
        ConnectivityState state = channel.getState(false);
        if (ConnectivityState.READY == state) {
            return true;
        }
        if (ConnectivityState.SHUTDOWN == state || ConnectivityState.TRANSIENT_FAILURE == state) {
            return false;
        }
        return ConnectivityState.IDLE == state || ConnectivityState.CONNECTING == state;
    }

    @Override
    public void setChannel(AbstractChannel channel) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public AbstractChannel getChannel() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int currentRequests() {
        return 0;
    }

    @Override
    public ResponseFuture asyncSend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public SofaResponse syncSend(SofaRequest request, int timeout) throws SofaRpcException {
        SofaResponse sofaResponse;
        SofaResponse sofaResponse2 = null;
        SofaRpcException throwable = null;
        try {
            RpcInternalContext context = RpcInternalContext.getContext();
            this.beforeSend(context, request);
            RpcInvokeContext invokeContext = RpcInvokeContext.getContext();
            invokeContext.put("_SOFA_REQUEST", request);
            invokeContext.put("_SOFA_CONSUMER_CONFIG", this.transportConfig.getConsumerConfig());
            sofaResponse = sofaResponse2 = this.tripleClientInvoker.invoke(request, timeout);
        }
        catch (Exception e) {
            try {
                throwable = this.convertToRpcException(e);
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (EventBus.isEnable(ClientSyncReceiveEvent.class)) {
                    EventBus.post(new ClientSyncReceiveEvent(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), request, sofaResponse2, throwable));
                }
                throw throwable2;
            }
        }
        if (EventBus.isEnable(ClientSyncReceiveEvent.class)) {
            EventBus.post(new ClientSyncReceiveEvent(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), request, sofaResponse2, throwable));
        }
        return sofaResponse;
    }

    @Override
    public void oneWaySend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void receiveRpcResponse(SofaResponse response) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void handleRpcRequest(SofaRequest request) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceCountManagedChannel getSharedChannel(ProviderInfo url) {
        String key = url.toString();
        ReferenceCountManagedChannel channel = (ReferenceCountManagedChannel)((Object)channelMap.get(key));
        if (this.channelAvailable(channel)) {
            channel.incrementAndGetCount();
            return channel;
        }
        if (channel != null) {
            channel.shutdownNow();
        }
        Object object = this.lock;
        synchronized (object) {
            channel = (ReferenceCountManagedChannel)((Object)channelMap.get(key));
            if (this.channelAvailable(channel)) {
                channel.incrementAndGetCount();
            } else {
                channel = new ReferenceCountManagedChannel(this.initChannel(url));
                channelMap.put(key, channel);
            }
        }
        return channel;
    }

    private ManagedChannel initChannel(ProviderInfo url) {
        ClientInterceptor clientHeaderClientInterceptor = this.buildClientHeaderClientInterceptor();
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort());
        builder.usePlaintext();
        builder.disableRetry();
        builder.intercept(new ClientInterceptor[]{clientHeaderClientInterceptor});
        builder.maxInboundMessageSize(11);
        return builder.build();
    }

    protected ClientInterceptor buildClientHeaderClientInterceptor() {
        return new ClientHeaderClientInterceptor();
    }

    protected void beforeSend(RpcInternalContext context, SofaRequest request) {
        context.setLocalAddress(this.localAddress());
        if (EventBus.isEnable(ClientBeforeSendEvent.class)) {
            EventBus.post(new ClientBeforeSendEvent(request));
        }
    }

    protected SofaRpcException convertToRpcException(Exception e) {
        if (e instanceof SofaRpcException) {
            SofaRpcException exception = (SofaRpcException)e;
            return exception;
        }
        Status status = Status.fromThrowable((Throwable)e);
        StatusException grpcException = status.asException();
        SofaRpcException exception = status.getCode() == Status.DEADLINE_EXCEEDED.getCode() ? new SofaTimeOutException((Throwable)grpcException) : (status.getCode() == Status.NOT_FOUND.getCode() ? new SofaRpcException(110, (Throwable)grpcException) : (status.getCode() == Status.UNAVAILABLE.getCode() ? new SofaRpcException(250, (Throwable)grpcException) : (status.getCode() == Status.RESOURCE_EXHAUSTED.getCode() ? new SofaRpcException(100, (Throwable)grpcException) : new SofaRpcException(299, (Throwable)grpcException))));
        return exception;
    }
}

