/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.triple;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.constant.TripleConstant;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.alipay.sofa.rpc.transport.triple.TripleInvoker;
import com.alipay.sofa.rpc.utils.SofaProtoUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import triple.Request;
import triple.Response;

public class TripleClientInvoker
implements TripleInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleClientInvoker.class);
    private static final String DEFAULT_SERIALIZATION = "hessian2";
    protected Channel channel;
    protected ConsumerConfig consumerConfig;
    protected Method sofaStub;
    protected boolean useGeneric;
    private Serializer serializer;
    private String serialization;

    public TripleClientInvoker(ConsumerConfig consumerConfig, Channel channel) {
        this.channel = channel;
        this.consumerConfig = consumerConfig;
        this.useGeneric = SofaProtoUtils.checkIfUseGeneric(consumerConfig);
        this.cacheCommonData(consumerConfig);
        if (!this.useGeneric) {
            Class<?> enclosingClass = consumerConfig.getProxyClass().getEnclosingClass();
            try {
                this.sofaStub = enclosingClass.getDeclaredMethod("getSofaStub", Channel.class, CallOptions.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("getSofaStub not found in enclosingClass" + enclosingClass.getName());
            }
        }
    }

    private void cacheCommonData(ConsumerConfig consumerConfig) {
        String serialization = consumerConfig.getSerialization();
        if (StringUtils.isBlank(serialization)) {
            serialization = this.getDefaultSerialization();
        }
        this.serialization = serialization;
        this.serializer = SerializerFactory.getSerializer(serialization);
    }

    protected String getDefaultSerialization() {
        return DEFAULT_SERIALIZATION;
    }

    @Override
    public SofaResponse invoke(SofaRequest sofaRequest, int timeout) throws Exception {
        if (!this.useGeneric) {
            SofaResponse sofaResponse = new SofaResponse();
            Object stub = this.sofaStub.invoke(null, this.channel, this.buildCustomCallOptions(sofaRequest, timeout), timeout);
            Method method = sofaRequest.getMethod();
            Object appResponse = method.invoke(stub, sofaRequest.getMethodArgs()[0]);
            sofaResponse.setAppResponse(appResponse);
            return sofaResponse;
        }
        String serviceName = sofaRequest.getInterfaceName();
        String methodName = sofaRequest.getMethodName();
        MethodDescriptor.Marshaller requestMarshaller = null;
        MethodDescriptor.Marshaller responseMarshaller = null;
        requestMarshaller = ProtoUtils.marshaller((Message)Request.getDefaultInstance());
        responseMarshaller = ProtoUtils.marshaller((Message)Response.getDefaultInstance());
        String fullMethodName = MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName);
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(fullMethodName).setSampledToLocalTracing(true).setRequestMarshaller(requestMarshaller).setResponseMarshaller(responseMarshaller).build();
        Request request = TripleClientInvoker.getRequest(sofaRequest, this.serialization, this.serializer);
        Response response = (Response)ClientCalls.blockingUnaryCall((Channel)this.channel, (MethodDescriptor)methodDescriptor, (CallOptions)this.buildCustomCallOptions(sofaRequest, timeout), (Object)request);
        SofaResponse sofaResponse = new SofaResponse();
        byte[] responseDate = response.getData().toByteArray();
        Class<?> returnType = sofaRequest.getMethod().getReturnType();
        if (returnType != Void.TYPE && responseDate != null && responseDate.length > 0) {
            Serializer responseSerializer = SerializerFactory.getSerializer(response.getSerializeType());
            Object appResponse = responseSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseDate), returnType, null);
            sofaResponse.setAppResponse(appResponse);
        }
        return sofaResponse;
    }

    public static Request getRequest(SofaRequest sofaRequest, String serialization, Serializer serializer) {
        Request.Builder builder = Request.newBuilder();
        builder.setSerializeType(serialization);
        String[] methodArgSigs = sofaRequest.getMethodArgSigs();
        Object[] methodArgs = sofaRequest.getMethodArgs();
        for (int i = 0; i < methodArgSigs.length; ++i) {
            Object arg = methodArgs[i];
            ByteString argByteString = ByteString.copyFrom((byte[])serializer.encode(arg, null).array());
            builder.addArgs(argByteString);
            builder.addArgTypes(methodArgSigs[i]);
        }
        return builder.build();
    }

    protected CallOptions buildCustomCallOptions(SofaRequest sofaRequest, int timeout) {
        CallOptions tripleCallOptions = CallOptions.DEFAULT;
        String target = this.consumerConfig.getParameter("interworking.target");
        if (StringUtils.isNotBlank(target)) {
            tripleCallOptions = tripleCallOptions.withAuthority(target);
        }
        if (timeout >= 0) {
            tripleCallOptions = tripleCallOptions.withDeadlineAfter((long)timeout, TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotBlank(this.consumerConfig.getUniqueId())) {
            tripleCallOptions = tripleCallOptions.withOption(TripleConstant.UNIQUE_ID, (Object)this.consumerConfig.getUniqueId());
        }
        return tripleCallOptions;
    }
}

