/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.common.utils.JSONUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerReceiveEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.triple.TripleHeadKeys;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerServiceDefinition;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TripleTracerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleTracerAdapter.class);
    private static final String USERID_KEY = "userid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beforeSend(SofaRequest sofaRequest, ConsumerConfig consumerConfig, Metadata requestHeader) {
        String target;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("sofa_head_method_name", sofaRequest.getMethodName());
        header.put("sofa_head_target_service", sofaRequest.getTargetServiceUniqueName());
        header.put("sofa_head_target_app", sofaRequest.getTargetAppName());
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.getCurrentSpan();
        if (clientSpan == null) {
            SelfLog.warn((String)("ClientSpan is null.Before call interface=" + sofaRequest.getInterfaceName() + ",method=" + sofaRequest.getMethodName()));
        } else {
            SofaTracerSpanContext sofaTracerSpanContext = clientSpan.getSofaTracerSpanContext();
            header.put(TripleHeadKeys.HEAD_KEY_TRACE_ID.name(), sofaTracerSpanContext.getTraceId());
            header.put(TripleHeadKeys.HEAD_KEY_RPC_ID.name(), sofaTracerSpanContext.getSpanId());
            header.put(TripleHeadKeys.HEAD_KEY_OLD_TRACE_ID.name(), sofaTracerSpanContext.getTraceId());
            header.put(TripleHeadKeys.HEAD_KEY_OLD_RPC_ID.name(), sofaTracerSpanContext.getSpanId());
            header.put(TripleHeadKeys.HEAD_KEY_BIZ_BAGGAGE_TYPE.name(), sofaTracerSpanContext.getBizSerializedBaggage());
            header.put(TripleHeadKeys.HEAD_KEY_SYS_BAGGAGE_TYPE.name(), sofaTracerSpanContext.getSysSerializedBaggage());
        }
        RpcInvokeContext internalContext = RpcInvokeContext.getContext();
        String route = (String)internalContext.get(USERID_KEY);
        if (StringUtils.isNotBlank(route)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(USERID_KEY, route);
            header.put(TripleHeadKeys.HEAD_KEY_UNIT_INFO.name(), JSONUtils.toJSONString(map));
        }
        if (StringUtils.isNotEmpty(consumerConfig.getUniqueId())) {
            header.put(TripleHeadKeys.HEAD_KEY_SERVICE_VERSION.name(), consumerConfig.getUniqueId());
        }
        header.put(TripleHeadKeys.HEAD_KEY_META_TYPE.name(), "rpc");
        header.put(TripleHeadKeys.HEAD_KEY_CURRENT_APP.name(), (String)sofaRequest.getRequestProp("app"));
        header.put(TripleHeadKeys.HEAD_KEY_CONSUMER_APP.name(), (String)sofaRequest.getRequestProp("app"));
        header.put(TripleHeadKeys.HEAD_KEY_PROTOCOL_TYPE.name(), (String)sofaRequest.getRequestProp("protocol"));
        header.put(TripleHeadKeys.HEAD_KEY_INVOKE_TYPE.name(), (String)sofaRequest.getRequestProp("type"));
        String source = consumerConfig.getParameter("interworking.source");
        if (StringUtils.isNotBlank(source)) {
            header.put(TripleHeadKeys.HEAD_KEY_SOURCE_TENANTID.name(), source);
        }
        if (StringUtils.isNotBlank(target = consumerConfig.getParameter("interworking.target"))) {
            header.put(TripleHeadKeys.HEAD_KEY_TARGET_TENANTID.name(), target);
        }
        for (Map.Entry entry : header.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            requestHeader.put(TripleHeadKeys.getKey((String)entry.getKey()), entry.getValue());
        }
        try {
            Set<Map.Entry<String, String>> customHeader = RpcInvokeContext.getContext().getCustomHeader().entrySet();
            for (Map.Entry<String, String> entry : customHeader) {
                if (!StringUtils.isNotBlank(entry.getValue())) continue;
                requestHeader.put(TripleHeadKeys.getKey(entry.getKey()), (Object)entry.getValue());
            }
        }
        finally {
            RpcInvokeContext.getContext().clearCustomHeader();
        }
    }

    public static void serverReceived(SofaRequest sofaRequest, ServerServiceDefinition serverServiceDefinition, ServerCall call, Metadata requestHeaders) {
        try {
            String serviceName;
            if (sofaRequest == null) {
                sofaRequest = new SofaRequest();
            }
            HashMap<String, Object> traceMap = new HashMap<String, Object>();
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_TARGET_SERVICE)) {
                sofaRequest.setTargetServiceUniqueName((String)requestHeaders.get(TripleHeadKeys.HEAD_KEY_TARGET_SERVICE));
                sofaRequest.setInterfaceName((String)requestHeaders.get(TripleHeadKeys.HEAD_KEY_TARGET_SERVICE));
            } else {
                serviceName = serverServiceDefinition.getServiceDescriptor().getName();
                sofaRequest.setTargetServiceUniqueName(serviceName);
                sofaRequest.setInterfaceName(serviceName);
            }
            serviceName = call.getMethodDescriptor().getServiceName();
            sofaRequest.setTargetServiceUniqueName(serviceName);
            sofaRequest.setInterfaceName(serviceName);
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_TARGET_APP)) {
                sofaRequest.setTargetAppName((String)requestHeaders.get(TripleHeadKeys.HEAD_KEY_TARGET_APP));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_OLD_TRACE_ID)) {
                traceMap.put("sofaTraceId", requestHeaders.get(TripleHeadKeys.HEAD_KEY_OLD_TRACE_ID));
            } else if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_TRACE_ID)) {
                traceMap.put("sofaTraceId", requestHeaders.get(TripleHeadKeys.HEAD_KEY_TRACE_ID));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_OLD_RPC_ID)) {
                traceMap.put("sofaRpcId", requestHeaders.get(TripleHeadKeys.HEAD_KEY_OLD_RPC_ID));
            } else if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_RPC_ID)) {
                traceMap.put("sofaRpcId", requestHeaders.get(TripleHeadKeys.HEAD_KEY_RPC_ID));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_SERVICE_VERSION)) {
                RpcInvokeContext.getContext().put("_SOFA_UNIQUE_ID", requestHeaders.get(TripleHeadKeys.HEAD_KEY_SERVICE_VERSION));
            } else {
                RpcInvokeContext.getContext().put("_SOFA_UNIQUE_ID", "");
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_SAMP_TYPE)) {
                traceMap.put("samp", requestHeaders.get(TripleHeadKeys.HEAD_KEY_SAMP_TYPE));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_CURRENT_APP)) {
                sofaRequest.addRequestProp("app", requestHeaders.get(TripleHeadKeys.HEAD_KEY_CURRENT_APP));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_PROTOCOL_TYPE)) {
                sofaRequest.addRequestProp("protocol", requestHeaders.get(TripleHeadKeys.HEAD_KEY_PROTOCOL_TYPE));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_INVOKE_TYPE)) {
                sofaRequest.addRequestProp("type", requestHeaders.get(TripleHeadKeys.HEAD_KEY_INVOKE_TYPE));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_BIZ_BAGGAGE_TYPE)) {
                traceMap.put("sofaPenAttrs", requestHeaders.get(TripleHeadKeys.HEAD_KEY_BIZ_BAGGAGE_TYPE));
            }
            if (requestHeaders.containsKey(TripleHeadKeys.HEAD_KEY_SYS_BAGGAGE_TYPE)) {
                traceMap.put("sysPenAttrs", requestHeaders.get(TripleHeadKeys.HEAD_KEY_SYS_BAGGAGE_TYPE));
            }
            if (!traceMap.isEmpty()) {
                sofaRequest.addRequestProp("rpc_trace_context", traceMap);
            }
            if (EventBus.isEnable(ServerReceiveEvent.class)) {
                EventBus.post(new ServerReceiveEvent(sofaRequest));
            }
            String remoteIp = "";
            SocketAddress socketAddress = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            if (socketAddress instanceof InetSocketAddress) {
                remoteIp = ((InetSocketAddress)socketAddress).getHostName();
            }
            String fullMethodName = call.getMethodDescriptor().getFullMethodName();
            String methodName = StringUtils.substringAfter(fullMethodName, serviceName + "/");
            sofaRequest.setMethodName(methodName);
            SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
            SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
            if (serverSpan != null) {
                serverSpan.setTag("service", sofaRequest.getTargetServiceUniqueName());
                serverSpan.setTag("method", methodName);
                serverSpan.setTag("remote.app", (String)sofaRequest.getRequestProp("app"));
                serverSpan.setTag("protocol", "tri");
                serverSpan.setTag("remote.ip", remoteIp);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("triple serverReceived tracer error", e);
        }
    }

    public static void serverSend(SofaRequest request, Metadata requestHeaders, SofaResponse response, Throwable throwable) {
        if (EventBus.isEnable(ServerSendEvent.class)) {
            if (request == null) {
                request = new SofaRequest();
            }
            if (request.getTargetServiceUniqueName() == null) {
                request.setTargetServiceUniqueName((String)requestHeaders.get(TripleHeadKeys.HEAD_KEY_TARGET_SERVICE));
            }
            if (request.getMethodName() == null) {
                request.setMethodName((String)requestHeaders.get(TripleHeadKeys.HEAD_KEY_METHOD_NAME));
            }
            EventBus.post(new ServerSendEvent(request, response, throwable));
        }
    }
}

