/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.utils;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class RegistryUtils {
    private static final String JAVA = "java";

    public static List<String> convertProviderToUrls(ProviderConfig providerConfig) {
        List<ServerConfig> servers = providerConfig.getServer();
        if (servers != null && !servers.isEmpty()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ServerConfig server : servers) {
                Integer port;
                StringBuilder sb = new StringBuilder(200);
                String host = server.getVirtualHost();
                if (host == null && (NetUtils.isLocalHost(host = server.getHost()) || NetUtils.isAnyHost(host))) {
                    host = SystemInfo.getLocalHost();
                }
                if ((port = server.getVirtualPort()) == null) {
                    port = server.getPort();
                }
                Map<String, String> metaData = RegistryUtils.convertProviderToMap(providerConfig, server);
                sb.append(server.getProtocol()).append("://").append(host).append(":").append(port).append(server.getContextPath()).append("?version=1.0").append(RegistryUtils.convertMap2Pair(metaData));
                urls.add(sb.toString());
            }
            return urls;
        }
        return null;
    }

    public static List<ProviderInfo> matchProviderInfos(ConsumerConfig consumerConfig, List<ProviderInfo> providerInfos) {
        String protocol = consumerConfig.getProtocol();
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        for (ProviderInfo providerInfo : providerInfos) {
            if (!providerInfo.getProtocolType().equalsIgnoreCase(protocol) || !StringUtils.equals(consumerConfig.getUniqueId(), providerInfo.getAttr("uniqueId"))) continue;
            result.add(providerInfo);
        }
        return result;
    }

    public static Map<String, String> convertProviderToMap(ProviderConfig providerConfig, ServerConfig server) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("uniqueId", providerConfig.getUniqueId());
        metaData.put("interface", providerConfig.getInterfaceId());
        metaData.put("timeout", String.valueOf(providerConfig.getTimeout()));
        metaData.put("delay", String.valueOf(providerConfig.getDelay()));
        metaData.put("id", providerConfig.getId());
        metaData.put("dynamic", String.valueOf(providerConfig.isDynamic()));
        metaData.put("weight", String.valueOf(providerConfig.getWeight()));
        metaData.put("accepts", String.valueOf(server.getAccepts()));
        metaData.put("startTime", String.valueOf(RpcRuntimeContext.now()));
        metaData.put("appName", providerConfig.getAppName());
        metaData.put("serialization", providerConfig.getSerialization());
        metaData.put("protocol", server.getProtocol());
        if (null != providerConfig.getParameters()) {
            metaData.putAll(providerConfig.getParameters());
        }
        metaData.put("language", JAVA);
        metaData.put("pid", RpcRuntimeContext.PID);
        metaData.put("rpcVer", String.valueOf(50805));
        return metaData;
    }

    public static String convertConsumerToUrl(ConsumerConfig consumerConfig) {
        StringBuilder sb = new StringBuilder(200);
        String host = SystemInfo.getLocalHost();
        sb.append(consumerConfig.getProtocol()).append("://").append(host).append("?version=1.0").append(RegistryUtils.getKeyPairs("uniqueId", consumerConfig.getUniqueId())).append(RegistryUtils.getKeyPairs("pid", RpcRuntimeContext.PID)).append(RegistryUtils.getKeyPairs("timeout", consumerConfig.getTimeout())).append(RegistryUtils.getKeyPairs("id", consumerConfig.getId())).append(RegistryUtils.getKeyPairs("generic", consumerConfig.isGeneric())).append(RegistryUtils.getKeyPairs("interface", consumerConfig.getInterfaceId())).append(RegistryUtils.getKeyPairs("appName", consumerConfig.getAppName())).append(RegistryUtils.getKeyPairs("serialization", consumerConfig.getSerialization())).append(RegistryUtils.getKeyPairs("startTime", RpcRuntimeContext.now())).append(RegistryUtils.convertMap2Pair(consumerConfig.getParameters()));
        RegistryUtils.addCommonAttrs(sb);
        return sb.toString();
    }

    public static String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }

    private static void addCommonAttrs(StringBuilder sb) {
        sb.append(RegistryUtils.getKeyPairs("pid", RpcRuntimeContext.PID));
        sb.append(RegistryUtils.getKeyPairs("language", JAVA));
        sb.append(RegistryUtils.getKeyPairs("rpcVer", "50805"));
    }

    private static String convertMap2Pair(Map<String, String> map) {
        if (CommonUtils.isEmpty(map)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(RegistryUtils.getKeyPairs(entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    public static String buildProviderPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/providers";
    }

    public static String buildConsumerPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/consumers";
    }

    public static String buildConfigPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/configs";
    }

    public static void processWarmUpWeight(ProviderInfo providerInfo) {
        String warmupTimeStr = providerInfo.getStaticAttr("warmupTime");
        String warmupWeightStr = providerInfo.getStaticAttr("warmupWeight");
        String startTimeStr = providerInfo.getStaticAttr("startTime");
        if (StringUtils.isNotBlank(warmupTimeStr) && StringUtils.isNotBlank(warmupWeightStr) && StringUtils.isNotBlank(startTimeStr)) {
            long warmupTime = CommonUtils.parseLong(warmupTimeStr, 0L);
            int warmupWeight = CommonUtils.parseInt(warmupWeightStr, Integer.parseInt(providerInfo.getStaticAttr("weight")));
            long startTime = CommonUtils.parseLong(startTimeStr, 0L);
            long warmupEndTime = startTime + warmupTime;
            providerInfo.setDynamicAttr("warmupWeight", warmupWeight);
            providerInfo.setDynamicAttr("warmupEndTime", warmupEndTime);
            providerInfo.setStatus(ProviderStatus.WARMING_UP);
        }
        providerInfo.getStaticAttrs().remove("warmupTime");
        providerInfo.getStaticAttrs().remove("warmupWeight");
    }

    public static <K, V> void initOrAddList(Map<K, List<V>> orginMap, K key, V needAdd) {
        List<V> listeners = orginMap.get(key);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<V>();
            listeners.add(needAdd);
            orginMap.put(key, listeners);
        } else {
            listeners.add(needAdd);
        }
    }

    public static String convertInstanceToUrl(String host, int port, Map<String, String> metaData) {
        if (metaData == null) {
            metaData = new HashMap<String, String>();
        }
        String uri = "";
        String protocol = metaData.get("protocol");
        if (StringUtils.isNotEmpty(protocol)) {
            uri = protocol + "://";
        }
        uri = uri + host + ":" + port;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : metaData.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            uri = uri + sb.replace(0, 1, "?").toString();
        }
        return uri;
    }

    public static String getServerHost(ServerConfig server) {
        String host = server.getVirtualHost();
        if (host == null && (NetUtils.isLocalHost(host = server.getHost()) || NetUtils.isAnyHost(host))) {
            host = SystemInfo.getLocalHost();
        }
        return host;
    }

    public static String buildUniqueName(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(config) + "@DEFAULT";
        }
        return ConfigUniqueNameGenerator.getUniqueName(config) + "@" + protocol;
    }
}

