/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.jackson;

import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.jackson.JacksonHelper;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Extension(value="json", code=12)
public class JacksonSerializer
extends AbstractSerializer {
    private ObjectMapper mapper = new ObjectMapper();
    private JacksonHelper jacksonHelper = new JacksonHelper();
    private static final String DESERIALIZATIONFEATURE_PREFIX = "sofa.rpc.codec.jackson.DeserializationFeature.";
    private static final String SERIALIZATIONFEATURE_PREFIX = "sofa.rpc.codec.jackson.SerializationFeature.";

    public JacksonSerializer() {
        Properties properties = System.getProperties();
        block0: for (String key : properties.stringPropertyNames()) {
            boolean state;
            String enumName;
            if (key.startsWith(DESERIALIZATIONFEATURE_PREFIX)) {
                enumName = StringUtils.substringAfter(key, DESERIALIZATIONFEATURE_PREFIX);
                for (DeserializationFeature deserializationFeature : DeserializationFeature.values()) {
                    if (!deserializationFeature.name().equals(enumName)) continue;
                    state = Boolean.parseBoolean(properties.getProperty(key));
                    this.mapper.configure(deserializationFeature, state);
                    break;
                }
            }
            if (!key.startsWith(SERIALIZATIONFEATURE_PREFIX)) continue;
            enumName = StringUtils.substringAfter(key, SERIALIZATIONFEATURE_PREFIX);
            for (DeserializationFeature deserializationFeature : SerializationFeature.values()) {
                if (!deserializationFeature.name().equals(enumName)) continue;
                state = Boolean.parseBoolean(properties.getProperty(key));
                this.mapper.configure((SerializationFeature)deserializationFeature, state);
                continue block0;
            }
        }
    }

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) throws SofaRpcException {
        if (object == null) {
            throw this.buildSerializeError("Unsupported null message!");
        }
        if (object instanceof SofaRequest) {
            return this.encodeSofaRequest((SofaRequest)object, context);
        }
        if (object instanceof SofaResponse) {
            return this.encodeSofaResponse((SofaResponse)object, context);
        }
        try {
            return new ByteArrayWrapperByteBuf(this.mapper.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw this.buildSerializeError(e.getMessage());
        }
    }

    protected AbstractByteBuf encodeSofaRequest(SofaRequest sofaRequest, Map<String, String> context) throws SofaRpcException {
        Object[] args = sofaRequest.getMethodArgs();
        if (args.length == 1) {
            return this.encode(args[0], context);
        }
        return this.encode(args, context);
    }

    protected AbstractByteBuf encodeSofaResponse(SofaResponse sofaResponse, Map<String, String> context) throws SofaRpcException {
        Object appResponse;
        AbstractByteBuf byteBuf = sofaResponse.isError() ? this.encode(sofaResponse.getErrorMsg(), context) : ((appResponse = sofaResponse.getAppResponse()) instanceof Throwable ? this.encode(((Throwable)appResponse).getMessage(), context) : this.encode(appResponse, context));
        return byteBuf;
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        Object result = null;
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        try {
            result = this.mapper.readValue(data.array(), clazz);
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage());
        }
        return result;
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        if (template instanceof SofaRequest) {
            this.decodeSofaRequest(data, (SofaRequest)template, context);
        } else if (template instanceof SofaResponse) {
            this.decodeSofaResponse(data, (SofaResponse)template, context);
        } else {
            throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
        }
    }

    private void decodeSofaRequest(AbstractByteBuf data, SofaRequest sofaRequest, Map<String, String> head) {
        JavaType[] requestClassList;
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        sofaRequest.setTargetServiceUniqueName(targetService);
        String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetService);
        sofaRequest.setInterfaceName(interfaceName);
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        sofaRequest.setMethodName(methodName);
        String targetApp = head.remove("sofa_head_target_app");
        if (targetApp != null) {
            sofaRequest.setTargetAppName(targetApp);
        }
        this.parseRequestHeader("rpc_trace_context", head, sofaRequest);
        if (RpcInvokeContext.isBaggageEnable()) {
            this.parseRequestHeader("rpc_req_baggage", head, sofaRequest);
        }
        for (Map.Entry<String, String> entry : head.entrySet()) {
            sofaRequest.addRequestProp(entry.getKey(), entry.getValue());
        }
        JavaType[] requestClassListDecode = requestClassList = this.jacksonHelper.getReqClass(targetService, sofaRequest.getMethodName());
        if (genericServiceMap.containsKey(targetService)) {
            requestClassListDecode = this.jacksonHelper.getReqClass((String)genericServiceMap.get(targetService), sofaRequest.getMethodName());
        }
        Object[] reqList = this.decode(data, requestClassListDecode);
        sofaRequest.setMethodArgs(reqList);
        sofaRequest.setMethodArgSigs(this.parseArgSigs(requestClassList));
    }

    private Object[] decode(AbstractByteBuf data, JavaType[] clazzList) throws SofaRpcException {
        if (clazzList == null || clazzList.length == 0) {
            return new Object[0];
        }
        Object[] args = new Object[clazzList.length];
        try {
            JsonNode node = this.mapper.readTree(data.array());
            if (node.isArray()) {
                if (clazzList.length == 1) {
                    if (!clazzList[0].isCollectionLikeType() && !clazzList[0].isArrayType()) {
                        throw this.buildDeserializeError("JSON data can't be json array");
                    }
                    args[0] = this.mapper.readValue(node.traverse(), clazzList[0]);
                    return args;
                }
                if (clazzList.length != node.size()) {
                    throw this.buildDeserializeError("JSON Array size is not equal parameter size");
                }
                for (int i = 0; i < clazzList.length; ++i) {
                    args[i] = this.mapper.readValue(node.get(i).traverse(), clazzList[i]);
                }
            } else {
                if (clazzList.length > 1) {
                    throw this.buildDeserializeError("JSON data must be json array");
                }
                args[0] = this.mapper.readValue(node.traverse(), clazzList[0]);
            }
            return args;
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    private String[] parseArgSigs(JavaType[] reqList) {
        ArrayList<String> argSigs = new ArrayList<String>();
        for (JavaType type : reqList) {
            argSigs.add(type.getRawClass().getName());
        }
        return argSigs.toArray(new String[argSigs.size()]);
    }

    private void parseRequestHeader(String key, Map<String, String> headerMap, SofaRequest sofaRequest) {
        HashMap<String, String> traceMap = new HashMap<String, String>(8);
        CodecUtils.treeCopyTo(key + ".", headerMap, traceMap, true);
        if (!traceMap.isEmpty()) {
            sofaRequest.addRequestProp(key, traceMap);
        }
    }

    private void decodeSofaResponse(AbstractByteBuf data, SofaResponse sofaResponse, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        boolean isError = false;
        if ("true".equals(head.remove("sofa_head_response_error"))) {
            isError = true;
        }
        if (!head.isEmpty()) {
            sofaResponse.setResponseProps(head);
        }
        if (isError) {
            String errorMessage = (String)this.decode(data, String.class, head);
            sofaResponse.setErrorMsg(errorMessage);
        } else {
            Object result;
            JavaType respType = this.jacksonHelper.getResClass(targetService, methodName);
            try {
                result = this.mapper.readValue(data.array(), respType);
            }
            catch (IOException e) {
                throw this.buildDeserializeError(e.getMessage());
            }
            sofaResponse.setAppResponse(result);
        }
    }
}

