/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.log.LogCodes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractSerializer
implements Serializer {
    protected static Map<String, String> genericServiceMap = new ConcurrentHashMap<String, String>();

    protected SofaRpcException buildSerializeError(String message) {
        return new SofaRpcException(this.getErrorCode(true), LogCodes.getLog("020050009", message));
    }

    protected SofaRpcException buildSerializeError(String message, Throwable throwable) {
        return new SofaRpcException(this.getErrorCode(true), LogCodes.getLog("020050009", message), throwable);
    }

    protected SofaRpcException buildDeserializeError(String message) {
        return new SofaRpcException(this.getErrorCode(false), LogCodes.getLog("020050009", message));
    }

    protected SofaRpcException buildDeserializeError(String message, Throwable throwable) {
        return new SofaRpcException(this.getErrorCode(false), LogCodes.getLog("020050009", message), throwable);
    }

    private int getErrorCode(boolean serialize) {
        if (RpcInternalContext.getContext().isProviderSide()) {
            return serialize ? 120 : 130;
        }
        if (RpcInternalContext.getContext().isConsumerSide()) {
            return serialize ? 220 : 230;
        }
        return 0;
    }

    public static void registerGenericService(String serviceName, String className) {
        if (StringUtils.isNotBlank(serviceName) && StringUtils.isNotBlank(className)) {
            genericServiceMap.put(serviceName, className);
        }
    }

    public static void clear() {
        genericServiceMap.clear();
    }
}

