/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.anno.support.AbstractLifecycle;
import com.alicp.jetcache.anno.support.CacheMonitorManager;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheMessageConsumer;
import com.alicp.jetcache.support.CacheNotifyMonitor;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultMetricsManager;
import com.alicp.jetcache.support.StatInfo;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCacheMonitorManager
extends AbstractLifecycle
implements CacheMonitorManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheMonitorManager.class);
    private final String sourceId = UUID.randomUUID().toString();
    private DefaultMetricsManager defaultMetricsManager;
    @Resource
    private GlobalCacheConfig globalCacheConfig;
    @Autowired(required=false)
    private Consumer<StatInfo> metricsCallback;
    @Autowired(required=false)
    private BroadcastManager broadcastManager;
    private boolean broadcastManagerInit;
    @Resource
    private ConfigProvider configProvider;
    private final ConcurrentHashMap<String, BroadcastManager> broadcastManagers = new ConcurrentHashMap();

    @Override
    public void addMonitors(String area, String cacheName, Cache cache, boolean syncLocal) {
        this.addMetricsMonitor(area, cacheName, cache);
        this.addNotifyMonitor(area, cacheName, cache, syncLocal);
    }

    protected void addNotifyMonitor(String area, String cacheName, Cache cache, boolean syncLocal) {
        if (!syncLocal) {
            return;
        }
        if (!(CacheUtil.getAbstractCache((Cache)cache) instanceof MultiLevelCache)) {
            return;
        }
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.globalCacheConfig.getRemoteCacheBuilders().get(area);
        if (cacheBuilder == null) {
            return;
        }
        BroadcastManager bm = this.broadcastManagers.computeIfAbsent(area, keyNotUse -> {
            if (this.broadcastManager != null) {
                if (!this.broadcastManagerInit) {
                    this.broadcastManager.startSubscribe((Consumer)new CacheMessageConsumer(this.sourceId, this.configProvider.getCacheManager()));
                    this.broadcastManagerInit = true;
                }
                return this.broadcastManager;
            }
            if (!cacheBuilder.supportBroadcast()) {
                return null;
            }
            ExternalCacheBuilder builderCopy = (ExternalCacheBuilder)cacheBuilder.clone();
            BroadcastManager result = builderCopy.broadcastManager(builderCopy.getBroadcastChannel());
            result.startSubscribe((Consumer)new CacheMessageConsumer(this.sourceId, this.configProvider.getCacheManager()));
            return result;
        });
        if (bm == null) {
            return;
        }
        CacheNotifyMonitor monitor = new CacheNotifyMonitor(bm, area, cacheName, cache, this.sourceId);
        cache.config().getMonitors().add(monitor);
    }

    protected void addMetricsMonitor(String area, String cacheName, Cache cache) {
        if (this.defaultMetricsManager != null) {
            MultiLevelCache mc;
            if ((cache = CacheUtil.getAbstractCache((Cache)cache)) instanceof MultiLevelCache && (mc = (MultiLevelCache)cache).caches().length == 2) {
                Cache local = mc.caches()[0];
                Cache remote = mc.caches()[1];
                DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(cacheName + "_local");
                local.config().getMonitors().add(localMonitor);
                DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(cacheName + "_remote");
                remote.config().getMonitors().add(remoteMonitor);
                this.defaultMetricsManager.add(new DefaultCacheMonitor[]{localMonitor, remoteMonitor});
            }
            DefaultCacheMonitor monitor = new DefaultCacheMonitor(cacheName);
            cache.config().getMonitors().add(monitor);
            this.defaultMetricsManager.add(new DefaultCacheMonitor[]{monitor});
        }
    }

    @Override
    protected void doInit() {
        this.initMetricsMonitor();
    }

    protected void initMetricsMonitor() {
        if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
            this.defaultMetricsManager = new DefaultMetricsManager(this.globalCacheConfig.getStatIntervalMinutes(), TimeUnit.MINUTES, this.metricsCallback);
            this.defaultMetricsManager.start();
        }
    }

    @Override
    protected void doShutdown() {
        this.shutdownMetricsMonitor();
        for (BroadcastManager m : this.broadcastManagers.values()) {
            if (!(m instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)m).close();
            }
            catch (Exception e) {
                logger.warn("BroadcastManager close fail", (Throwable)e);
            }
        }
    }

    protected void shutdownMetricsMonitor() {
        if (this.defaultMetricsManager != null) {
            this.defaultMetricsManager.stop();
        }
        this.defaultMetricsManager = null;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }

    public void setBroadcastManager(BroadcastManager broadcastManager) {
        this.broadcastManager = broadcastManager;
    }

    public void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }
}

