/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.field;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.RefreshPolicy;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.anno.CachePenetrationProtect;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CreateCache;
import com.alicp.jetcache.anno.method.CacheConfigUtil;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.PenetrationProtectConfig;
import java.lang.reflect.Field;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class CreateCacheWrapper {
    private Cache cache;
    private ConfigurableListableBeanFactory beanFactory;
    private CreateCache ann;
    private Field field;
    private RefreshPolicy refreshPolicy;
    private PenetrationProtectConfig protectConfig;

    public CreateCacheWrapper(ConfigurableListableBeanFactory beanFactory, CreateCache ann, Field field) {
        CachePenetrationProtect penetrateProtect;
        this.beanFactory = beanFactory;
        this.ann = ann;
        this.field = field;
        CacheRefresh cr = field.getAnnotation(CacheRefresh.class);
        if (cr != null) {
            this.refreshPolicy = CacheConfigUtil.parseRefreshPolicy(cr);
        }
        if ((penetrateProtect = field.getAnnotation(CachePenetrationProtect.class)) != null) {
            this.protectConfig = CacheConfigUtil.parsePenetrationProtectConfig(penetrateProtect);
        }
        this.init();
    }

    private void init() {
        GlobalCacheConfig globalCacheConfig = (GlobalCacheConfig)this.beanFactory.getBean(GlobalCacheConfig.class);
        ConfigProvider configProvider = (ConfigProvider)this.beanFactory.getBean(ConfigProvider.class);
        CachedAnnoConfig cac = new CachedAnnoConfig();
        cac.setArea(this.ann.area());
        cac.setName(this.ann.name());
        cac.setTimeUnit(this.ann.timeUnit());
        cac.setExpire(this.ann.expire());
        cac.setLocalExpire(this.ann.localExpire());
        cac.setCacheType(this.ann.cacheType());
        cac.setSyncLocal(this.ann.syncLocal());
        cac.setLocalLimit(this.ann.localLimit());
        cac.setSerialPolicy(this.ann.serialPolicy());
        cac.setKeyConvertor(this.ann.keyConvertor());
        cac.setRefreshPolicy(this.refreshPolicy);
        cac.setPenetrationProtectConfig(this.protectConfig);
        String cacheName = cac.getName();
        if (CacheConsts.isUndefined((String)cacheName)) {
            String[] hiddenPackages = globalCacheConfig.getHiddenPackages();
            CacheNameGenerator g = configProvider.createCacheNameGenerator(hiddenPackages);
            cacheName = g.generateCacheName(this.field);
        }
        this.cache = configProvider.getCacheContext().__createOrGetCache(cac, this.ann.area(), cacheName);
    }

    public Cache getCache() {
        return this.cache;
    }
}

