/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.field;

import com.alicp.jetcache.anno.CreateCache;
import com.alicp.jetcache.anno.field.CreateCacheWrapper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Component
public class CreateCacheAnnotationBeanPostProcessor
extends AutowiredAnnotationBeanPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(CreateCacheAnnotationBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>();
    private volatile boolean clearInited = false;
    private Method cleanMethod;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        return this.postProcessProperties(pvs, bean, beanName);
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) {
        InjectionMetadata metadata = this.findAutowiringMetadata(beanName, bean.getClass(), pvs);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of autowired dependencies failed", ex);
        }
        return pvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAutowiringMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = this.injectionMetadataCache.get(cacheKey);
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            Map<String, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(cacheKey);
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        this.clear(metadata, pvs);
                    }
                    try {
                        metadata = this.buildAutowiringMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect bean class [" + clazz.getName() + "] for autowiring metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    private void clear(InjectionMetadata obj, PropertyValues param) {
        if (!this.clearInited) {
            try {
                this.cleanMethod = InjectionMetadata.class.getMethod("clear", PropertyValues.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.clearInited = true;
        }
        if (this.cleanMethod != null) {
            try {
                this.cleanMethod.invoke((Object)obj, param);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private InjectionMetadata buildAutowiringMetadata(Class<?> clazz) {
        LinkedList elements = new LinkedList();
        Class<?> targetClass = clazz;
        do {
            final LinkedList currElements = new LinkedList();
            this.doWithLocalFields(targetClass, new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    CreateCache ann = field.getAnnotation(CreateCache.class);
                    if (ann != null) {
                        if (Modifier.isStatic(field.getModifiers())) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Autowired annotation is not supported on static fields: " + field);
                            }
                            return;
                        }
                        currElements.add(new AutowiredFieldElement(field, ann));
                    }
                }
            });
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private void doWithLocalFields(Class clazz, ReflectionUtils.FieldCallback fieldCallback) {
        Field[] fs;
        for (Field field : fs = clazz.getDeclaredFields()) {
            try {
                fieldCallback.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private Field field;
        private CreateCache ann;

        public AutowiredFieldElement(Field field, CreateCache ann) {
            super((Member)field, null);
            this.field = field;
            this.ann = ann;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            CreateCacheAnnotationBeanPostProcessor.this.beanFactory.registerDependentBean(beanName, "globalCacheConfig");
            CreateCacheWrapper wrapper = new CreateCacheWrapper(CreateCacheAnnotationBeanPostProcessor.this.beanFactory, this.ann, this.field);
            this.field.setAccessible(true);
            this.field.set(bean, wrapper.getCache());
        }
    }
}

