/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.internal;

import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ThreadLocalNamedInvoker;

public class PersistenceUnitBinder
extends AbstractBinder {
    private final ServletConfig servletConfig;
    public static final String PERSISTENCE_UNIT_PREFIX = "unit:";

    public PersistenceUnitBinder(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    @Override
    protected void configure() {
        this.bind(new PersistenceUnitInjectionResolver(this.servletConfig)).to(new GenericType<InjectionResolver<PersistenceUnit>>(){});
    }

    @Singleton
    private static class PersistenceUnitInjectionResolver
    implements InjectionResolver<PersistenceUnit> {
        private final Map<String, String> persistenceUnits = new HashMap<String, String>();

        private PersistenceUnitInjectionResolver(ServletConfig servletConfig) {
            Enumeration<String> parameterNames = servletConfig.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String key = parameterNames.nextElement();
                if (!key.startsWith(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX)) continue;
                this.persistenceUnits.put(key.substring(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX.length()), "java:comp/env/" + servletConfig.getInitParameter(key));
            }
        }

        @Override
        public Object resolve(Injectee injectee) {
            if (!injectee.getRequiredType().equals(EntityManagerFactory.class)) {
                return null;
            }
            PersistenceUnit annotation = injectee.getParent().getAnnotation(PersistenceUnit.class);
            String unitName = annotation.unitName();
            if (!this.persistenceUnits.containsKey(unitName)) {
                throw new ContainerException(LocalizationMessages.PERSISTENCE_UNIT_NOT_CONFIGURED(unitName));
            }
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, new ThreadLocalNamedInvoker(this.persistenceUnits.get(unitName)));
        }

        @Override
        public boolean isConstructorParameterIndicator() {
            return false;
        }

        @Override
        public boolean isMethodParameterIndicator() {
            return false;
        }

        @Override
        public Class<PersistenceUnit> getAnnotation() {
            return PersistenceUnit.class;
        }
    }
}

