/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.trogdor.basic.BasicNode;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Topology;

public class BasicTopology
implements Topology {
    private final NavigableMap<String, Node> nodes;

    public BasicTopology(NavigableMap<String, Node> nodes) {
        this.nodes = nodes;
    }

    public BasicTopology(JsonNode configRoot) {
        if (!configRoot.isObject()) {
            throw new RuntimeException("Expected the 'nodes' element to be a JSON object.");
        }
        this.nodes = new TreeMap<String, Node>();
        Iterator<String> iter = configRoot.fieldNames();
        while (iter.hasNext()) {
            String nodeName = iter.next();
            JsonNode nodeConfig = configRoot.get(nodeName);
            BasicNode node = new BasicNode(nodeName, nodeConfig);
            this.nodes.put(nodeName, node);
        }
    }

    @Override
    public Node node(String id) {
        return (Node)this.nodes.get(id);
    }

    @Override
    public NavigableMap<String, Node> nodes() {
        return this.nodes;
    }
}

