/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Field;
import io.debezium.transforms.ScriptingTransformation;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;

@Incubating
public class ContentBasedRouter<R extends ConnectRecord<R>>
extends ScriptingTransformation<R> {
    public static final Field EXPRESSION = Field.create("topic.expression").withDisplayName("Topic name expression").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("An expression determining the new name of the topic the record should use. When null the record is delivered to the original topic.");

    @Override
    protected R doApply(R record) {
        String topicName = this.engine.eval((ConnectRecord<?>)record, String.class);
        return topicName == null ? record : ((ConnectRecord)record).newRecord(topicName, ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp(), ((ConnectRecord)record).headers());
    }

    @Override
    protected Field expressionField() {
        return EXPRESSION;
    }
}

