/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class ZonedTimestamp {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    public static final String SCHEMA_NAME = "io.debezium.time.ZonedTimestamp";

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return ZonedTimestamp.builder().build();
    }

    public static String toIsoString(Object value, ZoneId defaultZone, TemporalAdjuster adjuster) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof OffsetDateTime) {
            return ZonedTimestamp.toIsoString((OffsetDateTime)value, adjuster);
        }
        if (value instanceof ZonedDateTime) {
            return ZonedTimestamp.toIsoString((ZonedDateTime)value, adjuster);
        }
        if (value instanceof OffsetTime) {
            return ZonedTimestamp.toIsoString((OffsetTime)value, adjuster);
        }
        if (value instanceof Date) {
            return ZonedTimestamp.toIsoString((Date)value, defaultZone, adjuster);
        }
        throw new IllegalArgumentException("Unable to convert to OffsetDateTime from unexpected value '" + value + "' of type " + value.getClass().getName());
    }

    public static String toIsoString(OffsetDateTime timestamp, TemporalAdjuster adjuster) {
        if (adjuster != null) {
            timestamp = timestamp.with(adjuster);
        }
        return timestamp.format(FORMATTER);
    }

    public static String toIsoString(ZonedDateTime timestamp, TemporalAdjuster adjuster) {
        if (adjuster != null) {
            timestamp = timestamp.with(adjuster);
        }
        return timestamp.format(FORMATTER);
    }

    public static String toIsoString(OffsetTime timestamp, TemporalAdjuster adjuster) {
        if (adjuster != null) {
            timestamp = timestamp.with(adjuster);
        }
        return timestamp.format(FORMATTER);
    }

    public static String toIsoString(Date timestamp, ZoneId zoneId, TemporalAdjuster adjuster) {
        if (timestamp instanceof Timestamp) {
            return ZonedTimestamp.toIsoString((Timestamp)timestamp, zoneId, adjuster);
        }
        if (timestamp instanceof java.sql.Date) {
            return ZonedTimestamp.toIsoString((java.sql.Date)timestamp, zoneId, adjuster);
        }
        if (timestamp instanceof Time) {
            return ZonedTimestamp.toIsoString((Time)timestamp, zoneId, adjuster);
        }
        return timestamp.toInstant().atZone(zoneId).format(FORMATTER);
    }

    public static String toIsoString(Timestamp timestamp, ZoneId zoneId, TemporalAdjuster adjuster) {
        Instant instant = timestamp.toInstant();
        if (adjuster != null) {
            instant = instant.with(adjuster);
        }
        ZonedDateTime zdt = instant.atZone(zoneId);
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(java.sql.Date date, ZoneId zoneId, TemporalAdjuster adjuster) {
        LocalDate localDate = date.toLocalDate();
        if (adjuster != null) {
            localDate = localDate.with(adjuster);
        }
        ZonedDateTime zdt = ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, zoneId);
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(Time time, ZoneId zoneId, TemporalAdjuster adjuster) {
        LocalTime localTime = time.toLocalTime();
        if (adjuster != null) {
            localTime = localTime.with(adjuster);
        }
        ZonedDateTime zdt = ZonedDateTime.of(Conversions.EPOCH, localTime, zoneId);
        return zdt.format(FORMATTER);
    }

    private ZonedTimestamp() {
    }
}

